/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load.text;

import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.event.impl.WordEvent;
import com.topologi.diffx.event.lang.CommonWordsEnglish;
import com.topologi.diffx.event.lang.Repertory;
import com.topologi.diffx.load.text.TextTokeniser;
import java.util.NoSuchElementException;

public final class CharactersTokeniser
implements TextTokeniser {
    private static final byte WHITE = 0;
    private static final byte TEXT = 1;
    private final CharSequence seq;
    private int max = -1;
    private int marker = 0;

    public CharactersTokeniser(CharSequence charSequence) throws NullPointerException {
        if (charSequence == null) {
            throw new NullPointerException("The string buffer cannot be null.");
        }
        this.seq = charSequence;
    }

    public int countTokens() {
        if (this.seq.length() == 0) {
            return 0;
        }
        if (this.max >= 0) {
            return this.max;
        }
        byte by = -1;
        int n = 0;
        for (int i = 0; i < this.seq.length(); ++i) {
            if (by == CharactersTokeniser.getType(this.seq.charAt(i))) continue;
            by = CharactersTokeniser.getType(this.seq.charAt(i));
            ++n;
        }
        this.max = n;
        return n;
    }

    public TextEvent nextToken() throws NoSuchElementException {
        if (this.marker == this.seq.length()) {
            throw new NoSuchElementException("All tokens have been returned.");
        }
        byte by = CharactersTokeniser.getType(this.seq.charAt(this.marker));
        for (int i = this.marker; i < this.seq.length(); ++i) {
            if (by == CharactersTokeniser.getType(this.seq.charAt(i))) continue;
            TextEvent textEvent = this.newToken(by, this.marker, i);
            this.marker = i;
            return textEvent;
        }
        TextEvent textEvent = this.newToken(by, this.marker, this.seq.length());
        this.marker = this.seq.length();
        return textEvent;
    }

    private static byte getType(char c) {
        return Character.isWhitespace(c) ? (byte)0 : 1;
    }

    private TextEvent newToken(byte by, int n, int n2) {
        switch (by) {
            case 1: {
                String string = ((Object)this.seq.subSequence(n, n2)).toString();
                if (CommonWordsEnglish.contains(string)) {
                    return CommonWordsEnglish.get(string);
                }
                return new WordEvent(string);
            }
            case 0: {
                return SpaceEvent.getInstance(this.seq.subSequence(n, n2));
            }
        }
        throw new NoSuchElementException("Cannot create token of unknown type.");
    }

    public void useRepertory(Repertory repertory) {
    }
}

