/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.format;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.CharEvent;
import com.topologi.diffx.event.impl.CharactersEventBase;
import com.topologi.diffx.event.impl.IgnorableSpaceEvent;
import com.topologi.diffx.event.impl.LineEvent;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.event.impl.WordEvent;
import com.topologi.diffx.format.DiffXFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class ShortStringFormatter
implements DiffXFormatter {
    private final Writer out;

    public ShortStringFormatter() throws IOException {
        this(new PrintWriter(System.out));
    }

    public ShortStringFormatter(Writer writer) throws IOException {
        this.out = writer;
    }

    public void format(DiffXEvent diffXEvent) throws IOException, IllegalStateException {
        this.out.write(ShortStringFormatter.toShortString(diffXEvent));
    }

    public void insert(DiffXEvent diffXEvent) throws IOException, IllegalStateException {
        this.out.write("+");
        this.out.write(ShortStringFormatter.toShortString(diffXEvent));
    }

    public void delete(DiffXEvent diffXEvent) throws IOException, IllegalStateException {
        this.out.write("-");
        this.out.write(ShortStringFormatter.toShortString(diffXEvent));
    }

    public void setConfig(DiffXConfig diffXConfig) {
    }

    public static String toShortString(DiffXEvent diffXEvent) {
        if (diffXEvent instanceof OpenElementEvent) {
            return '<' + ((OpenElementEvent)diffXEvent).getName() + '>';
        }
        if (diffXEvent instanceof CloseElementEvent) {
            return "</" + ((CloseElementEvent)diffXEvent).getName() + '>';
        }
        if (diffXEvent instanceof AttributeEvent) {
            return "@" + ((AttributeEvent)diffXEvent).getName();
        }
        if (diffXEvent instanceof WordEvent) {
            return '\"' + ((CharactersEventBase)diffXEvent).getCharacters() + '\"';
        }
        if (diffXEvent instanceof SpaceEvent) {
            return "_s_";
        }
        if (diffXEvent instanceof CharEvent) {
            return '\'' + ((CharactersEventBase)diffXEvent).getCharacters() + '\'';
        }
        if (diffXEvent instanceof IgnorableSpaceEvent) {
            return "_i_";
        }
        if (diffXEvent instanceof LineEvent) {
            return "L#" + ((LineEvent)diffXEvent).getLineNumber();
        }
        return "???";
    }
}

