/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.algorithm;

import com.topologi.diffx.algorithm.DiffXAlgorithmBase;
import com.topologi.diffx.algorithm.ElementState;
import com.topologi.diffx.algorithm.Matrix;
import com.topologi.diffx.algorithm.MatrixInt;
import com.topologi.diffx.algorithm.MatrixShort;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.format.DiffXFormatter;
import com.topologi.diffx.format.ShortStringFormatter;
import com.topologi.diffx.sequence.EventSequence;
import java.io.IOException;

public final class DiffXFitopsy
extends DiffXAlgorithmBase {
    private static final boolean DEBUG = false;
    private transient Matrix matrix;
    private transient ElementState estate = new ElementState();

    public DiffXFitopsy(EventSequence eventSequence, EventSequence eventSequence2) {
        super(eventSequence, eventSequence2);
        this.matrix = DiffXFitopsy.setupMatrix(eventSequence, eventSequence2);
    }

    public int length() {
        if (this.length1 == 0 || this.length2 == 0) {
            this.length = 0;
        }
        if (this.length < 0) {
            this.matrix.setup(this.length1 + 1, this.length2 + 1);
            for (int i = this.length1; i >= 0; --i) {
                for (int j = this.length2; j >= 0; --j) {
                    if (i >= this.length1 || j >= this.length2) {
                        this.matrix.set(i, j, 0);
                        continue;
                    }
                    if (this.sequence1.getEvent(i).equals(this.sequence2.getEvent(j))) {
                        this.matrix.incrementPathBy(i, j, 1);
                        continue;
                    }
                    this.matrix.incrementByMaxPath(i, j);
                }
            }
            this.length = this.matrix.get(0, 0);
        }
        return this.length;
    }

    public void process(DiffXFormatter diffXFormatter) throws IOException {
        this.processEmpty(diffXFormatter);
        if (this.length1 == 0 || this.length2 == 0) {
            return;
        }
        this.length();
        int n = 0;
        int n2 = 0;
        DiffXEvent diffXEvent = this.sequence1.getEvent(n);
        DiffXEvent diffXEvent2 = this.sequence2.getEvent(n2);
        while (n < this.length1 && n2 < this.length2) {
            diffXEvent = this.sequence1.getEvent(n);
            diffXEvent2 = this.sequence2.getEvent(n2);
            if (this.matrix.isGreaterX(n, n2)) {
                if (this.estate.okInsert(diffXEvent)) {
                    diffXFormatter.insert(diffXEvent);
                    this.estate.insert(diffXEvent);
                    ++n;
                    continue;
                }
                if (diffXEvent.equals(diffXEvent2) && this.estate.okFormat(diffXEvent)) {
                    diffXFormatter.format(diffXEvent);
                    this.estate.format(diffXEvent);
                    ++n;
                    ++n2;
                    continue;
                }
                if (!this.estate.okDelete(diffXEvent2)) break;
                diffXFormatter.delete(diffXEvent2);
                this.estate.delete(diffXEvent2);
                ++n2;
                continue;
            }
            if (this.matrix.isGreaterY(n, n2)) {
                if (this.estate.okDelete(diffXEvent2)) {
                    diffXFormatter.delete(diffXEvent2);
                    this.estate.delete(diffXEvent2);
                    ++n2;
                    continue;
                }
                if (diffXEvent.equals(diffXEvent2) && this.estate.okFormat(diffXEvent)) {
                    diffXFormatter.format(diffXEvent);
                    this.estate.format(diffXEvent);
                    ++n;
                    ++n2;
                    continue;
                }
                if (!this.estate.okInsert(diffXEvent)) break;
                diffXFormatter.insert(diffXEvent);
                this.estate.insert(diffXEvent);
                ++n;
                continue;
            }
            if (!this.matrix.isSameXY(n, n2)) break;
            if (diffXEvent.equals(diffXEvent2) && this.estate.okFormat(diffXEvent)) {
                diffXFormatter.format(diffXEvent);
                this.estate.format(diffXEvent);
                ++n;
                ++n2;
                continue;
            }
            if (this.estate.okInsert(diffXEvent) && (!(diffXEvent2 instanceof AttributeEvent) || diffXEvent instanceof AttributeEvent)) {
                this.estate.insert(diffXEvent);
                diffXFormatter.insert(diffXEvent);
                ++n;
                continue;
            }
            if (!this.estate.okDelete(diffXEvent2) || diffXEvent instanceof AttributeEvent && !(diffXEvent2 instanceof AttributeEvent)) break;
            diffXFormatter.delete(diffXEvent2);
            this.estate.delete(diffXEvent2);
            ++n2;
        }
        while (n < this.length1) {
            this.estate.insert(this.sequence1.getEvent(n));
            diffXFormatter.insert(this.sequence1.getEvent(n));
            ++n;
        }
        while (n2 < this.length2) {
            this.estate.delete(this.sequence2.getEvent(n2));
            diffXFormatter.delete(this.sequence2.getEvent(n2));
            ++n2;
        }
    }

    private void processEmpty(DiffXFormatter diffXFormatter) throws IOException {
        int n;
        if (this.length1 == 0) {
            for (n = 0; n < this.length2; ++n) {
                diffXFormatter.delete(this.sequence2.getEvent(n));
            }
        }
        if (this.length2 == 0) {
            for (n = 0; n < this.length1; ++n) {
                diffXFormatter.insert(this.sequence1.getEvent(n));
            }
        }
    }

    private static Matrix setupMatrix(EventSequence eventSequence, EventSequence eventSequence2) {
        int n;
        int n2 = 0;
        for (n = 0; n < eventSequence.size(); ++n) {
            n2 += eventSequence.getEvent(n).getWeight();
        }
        for (n = 0; n < eventSequence2.size(); ++n) {
            n2 += eventSequence2.getEvent(n).getWeight();
        }
        if (n2 > Short.MAX_VALUE) {
            return new MatrixInt();
        }
        return new MatrixShort();
    }

    private int maxWeight(DiffXEvent diffXEvent, DiffXEvent diffXEvent2) {
        return diffXEvent.getWeight() > diffXEvent2.getWeight() ? diffXEvent.getWeight() : diffXEvent2.getWeight();
    }

    private void printLost(int n, int n2) {
        DiffXEvent diffXEvent = this.sequence1.getEvent(n);
        DiffXEvent diffXEvent2 = this.sequence2.getEvent(n2);
        System.err.println("(!) Ambiguous choice in (" + n + "," + n2 + ")");
        System.err.println(" ? +" + ShortStringFormatter.toShortString(diffXEvent));
        System.err.println(" ? -" + ShortStringFormatter.toShortString(diffXEvent2));
        System.err.println(" current=" + ShortStringFormatter.toShortString(this.estate.current()));
        System.err.println(" value in X+1=" + this.matrix.get(n + 1, n2));
        System.err.println(" value in Y+1=" + this.matrix.get(n, n2 + 1));
        System.err.println(" equals=" + diffXEvent.equals(diffXEvent2));
        System.err.println(" greaterX=" + this.matrix.isGreaterX(n, n2));
        System.err.println(" greaterY=" + this.matrix.isGreaterY(n, n2));
        System.err.println(" sameXY=" + this.matrix.isSameXY(n, n2));
        System.err.println(" okFormat1=" + this.estate.okFormat(diffXEvent));
        System.err.println(" okFormat2=" + this.estate.okFormat(diffXEvent2));
        System.err.println(" okInsert=" + this.estate.okInsert(diffXEvent));
        System.err.println(" okDelete=" + this.estate.okDelete(diffXEvent2));
    }
}

