/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db.internal;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Sequence;
import com.sleepycat.db.SequenceStats;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.db_javaJNI;

public class DbSequence {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    public Sequence wrapper;

    protected DbSequence(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DbSequence obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int flags) throws DatabaseException {
        try {
            this.close0(flags);
        }
        finally {
            this.swigCPtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(DbTxn txn, int flags) throws DatabaseException {
        try {
            this.remove0(txn, flags);
        }
        finally {
            this.swigCPtr = 0L;
        }
    }

    public DbSequence(Db db, int flags) throws DatabaseException {
        this(db_javaJNI.new_DbSequence(Db.getCPtr(db), flags), true);
    }

    void close0(int flags) {
        db_javaJNI.DbSequence_close0(this.swigCPtr, flags);
    }

    public long get(DbTxn txnid, int delta, int flags) throws DatabaseException {
        return db_javaJNI.DbSequence_get(this.swigCPtr, DbTxn.getCPtr(txnid), delta, flags);
    }

    public int get_cachesize() throws DatabaseException {
        return db_javaJNI.DbSequence_get_cachesize(this.swigCPtr);
    }

    public Db get_db() throws DatabaseException {
        long cPtr = db_javaJNI.DbSequence_get_db(this.swigCPtr);
        return cPtr == 0L ? null : new Db(cPtr, false);
    }

    public int get_flags() throws DatabaseException {
        return db_javaJNI.DbSequence_get_flags(this.swigCPtr);
    }

    public void get_key(DatabaseEntry key) throws DatabaseException {
        db_javaJNI.DbSequence_get_key(this.swigCPtr, key);
    }

    public long get_range_min() throws DatabaseException {
        return db_javaJNI.DbSequence_get_range_min(this.swigCPtr);
    }

    public long get_range_max() throws DatabaseException {
        return db_javaJNI.DbSequence_get_range_max(this.swigCPtr);
    }

    public void initial_value(long val) throws DatabaseException {
        db_javaJNI.DbSequence_initial_value(this.swigCPtr, val);
    }

    public void open(DbTxn txnid, DatabaseEntry key, int flags) throws DatabaseException {
        db_javaJNI.DbSequence_open(this.swigCPtr, DbTxn.getCPtr(txnid), key, flags);
    }

    void remove0(DbTxn txnid, int flags) {
        db_javaJNI.DbSequence_remove0(this.swigCPtr, DbTxn.getCPtr(txnid), flags);
    }

    public void set_cachesize(int size) throws DatabaseException {
        db_javaJNI.DbSequence_set_cachesize(this.swigCPtr, size);
    }

    public void set_flags(int flags) throws DatabaseException {
        db_javaJNI.DbSequence_set_flags(this.swigCPtr, flags);
    }

    public void set_range(long min, long max) throws DatabaseException {
        db_javaJNI.DbSequence_set_range(this.swigCPtr, min, max);
    }

    public SequenceStats stat(int flags) throws DatabaseException {
        return db_javaJNI.DbSequence_stat(this.swigCPtr, flags);
    }
}

