/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class ReplicationManagerStartPolicy {
    public static final ReplicationManagerStartPolicy REP_MASTER = new ReplicationManagerStartPolicy("REP_MASTER", 3);
    public static final ReplicationManagerStartPolicy REP_CLIENT = new ReplicationManagerStartPolicy("REP_CLIENT", 1);
    public static final ReplicationManagerStartPolicy REP_ELECTION = new ReplicationManagerStartPolicy("REP_ELECTION", 2);
    private String statusName;
    private int id;

    static ReplicationManagerStartPolicy fromInt(int type) {
        switch (type) {
            case 3: {
                return REP_MASTER;
            }
            case 1: {
                return REP_CLIENT;
            }
            case 2: {
                return REP_ELECTION;
            }
        }
        throw new IllegalArgumentException("Unknown rep start policy: " + type);
    }

    private ReplicationManagerStartPolicy(String statusName, int id) {
        this.statusName = statusName;
        this.id = id;
    }

    int getId() {
        return this.id;
    }

    public String toString() {
        return "ReplicationManagerStartPolicy." + this.statusName;
    }
}

