/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Comparator;

public final class EqualPolygon
extends Polygon {
    private static final Comparator comparator = new PointsComparator();

    public EqualPolygon() {
    }

    public EqualPolygon(int[] nArray, int[] nArray2, int n) {
        this.xpoints = new int[n];
        this.ypoints = new int[n];
        System.arraycopy(nArray, 0, this.xpoints, 0, this.xpoints.length);
        System.arraycopy(nArray2, 0, this.ypoints, 0, this.ypoints.length);
        this.npoints = n;
    }

    public EqualPolygon(Polygon polygon) {
        super(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public EqualPolygon(Rectangle rectangle) {
        super(new int[]{rectangle.x, rectangle.x + rectangle.width, rectangle.x + rectangle.width, rectangle.x}, new int[]{rectangle.y, rectangle.y, rectangle.y + rectangle.height, rectangle.y + rectangle.height}, 4);
    }

    public EqualPolygon(int[] nArray, int[] nArray2) {
        super(nArray, nArray2, nArray.length);
    }

    public void moveTo(int n, int n2) {
        this.addPoint(n, n2);
    }

    public void lineTo(int n, int n2) {
        this.addPoint(n, n2);
    }

    public Object clone() {
        return new EqualPolygon(this.xpoints, this.ypoints, this.xpoints.length);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("EqualPolygon: ");
        for (int i = 0; i < this.npoints; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(this.xpoints[i]);
            stringBuffer.append(',');
            stringBuffer.append(this.ypoints[i]);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.arrayHashCode(this.xpoints) ^ this.arrayHashCode(this.ypoints);
    }

    private int arrayHashCode(int[] nArray) {
        int n = 0;
        for (int i = 0; i < this.npoints; ++i) {
            n += nArray[i] ^ i;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Polygon) {
            Polygon polygon = (Polygon)object;
            int[] nArray = polygon.xpoints;
            int[] nArray2 = polygon.ypoints;
            boolean bl = Arrays.equals(this.xpoints, nArray) && Arrays.equals(this.ypoints, nArray2);
            return bl &= polygon.npoints == this.npoints;
        }
        return false;
    }

    private static class PointsComparator
    implements Comparator {
        private PointsComparator() {
        }

        public int compare(Object object, Object object2) {
            Point point = (Point)object;
            Point point2 = (Point)object2;
            int n = point.y * (point.x - point2.x) - point2.y * (point2.x - point.x);
            return n;
        }
    }
}

