/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;

public abstract class TabDisplayerUI
extends ComponentUI {
    protected SingleSelectionModel selectionModel = null;
    protected final TabDisplayer displayer;

    protected TabDisplayerUI(TabDisplayer tabDisplayer) {
        this.displayer = tabDisplayer;
    }

    public void installUI(JComponent jComponent) {
        this.selectionModel = this.createSelectionModel();
        this.installSelectionModel();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallSelectionModel();
    }

    public abstract Polygon getExactTabIndication(int var1);

    public abstract Polygon getInsertTabIndication(int var1);

    public abstract int tabForCoordinate(Point var1);

    public abstract Rectangle getTabRect(int var1, Rectangle var2);

    public Image createImageOfTab(int n) {
        return null;
    }

    protected abstract SingleSelectionModel createSelectionModel();

    protected final boolean shouldPerformAction(String string, int n, MouseEvent mouseEvent) {
        TabActionEvent tabActionEvent = new TabActionEvent((Object)this.displayer, string, n, mouseEvent);
        this.displayer.postActionEvent(tabActionEvent);
        return !tabActionEvent.isConsumed();
    }

    public void makeTabVisible(int n) {
    }

    private void installSelectionModel() {
        this.displayer.setSelectionModel(this.selectionModel);
    }

    private void uninstallSelectionModel() {
        this.displayer.setSelectionModel(null);
    }

    public abstract String getCommandAtPoint(Point var1);

    public abstract int dropIndexOfPoint(Point var1);

    public abstract void registerShortcuts(JComponent var1);

    public abstract void unregisterShortcuts(JComponent var1);
}

