/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SchemaLocator {
    public String documentLocation;
    public String location;
    public int schemaDeclarationLine = -1;
    private Reader reader;
    private URL locationURL;
    private boolean streamProvided = false;
    private EntityResolver resolver;
    private String downloadedContent = null;
    private byte[] binaryDownloadedContent = null;

    public SchemaLocator(String string) {
        this.location = string;
    }

    public SchemaLocator(String string, String string2) {
        this.location = string2;
        this.documentLocation = string;
    }

    public SchemaLocator(String string, String string2, EntityResolver entityResolver) {
        this(string, string2);
        this.resolver = entityResolver;
    }

    public SchemaLocator(URL uRL) {
        this.locationURL = uRL;
    }

    public SchemaLocator(InputStream inputStream) {
        this.reader = new InputStreamReader(inputStream);
        this.streamProvided = true;
    }

    public boolean streamProvided() {
        return this.streamProvided;
    }

    public SchemaLocator(InputStream inputStream, String string) {
        this(inputStream);
        this.location = string;
    }

    public String getSource() {
        File file;
        if (this.location.indexOf("://") > -1) {
            return this.location;
        }
        if (this.documentLocation != null && this.documentLocation.indexOf("://") > -1) {
            String string = this.documentLocation;
            int n = string.lastIndexOf("/");
            string = string.substring(0, n + 1);
            string = string + this.location;
            return string;
        }
        if (this.location.startsWith("file:/")) {
            this.location = this.location.substring(6);
        }
        if ((file = new File(this.location)).exists()) {
            return this.location;
        }
        file = new File(new File(this.documentLocation).getParentFile(), this.location);
        return file.toString();
    }

    public SchemaLocator(Reader reader) {
        this.reader = reader;
    }

    public InputStream getInputStream() throws Exception {
        Object object;
        Object object2;
        if (this.binaryDownloadedContent != null) {
            return new ByteArrayInputStream(this.binaryDownloadedContent);
        }
        InputStream inputStream = null;
        if (this.locationURL != null) {
            inputStream = this.locationURL.openStream();
        }
        if (inputStream == null) {
            if (this.resolver != null && (object2 = (Object)this.resolver.resolveEntity(null, this.location)) != null) {
                inputStream = ((InputSource)object2).getByteStream();
            }
            if (inputStream == null) {
                if (this.location.indexOf("://") > -1) {
                    inputStream = new URL(this.location).openStream();
                } else if (this.documentLocation != null && this.documentLocation.indexOf("://") > -1) {
                    int n = this.documentLocation.lastIndexOf("/");
                    object = this.documentLocation.substring(0, n + 1);
                    inputStream = new URL((String)object + this.location).openStream();
                }
            }
        }
        if (inputStream == null) {
            if (this.documentLocation == null) {
                inputStream = new FileInputStream(this.location);
            }
            if (this.documentLocation != null) {
                object2 = new File(this.documentLocation);
                object = new File(((File)object2).getParentFile(), this.location);
                inputStream = ((File)object).exists() ? new FileInputStream((File)object) : new FileInputStream(this.location);
            }
        }
        if (inputStream == null) {
            throw new Exception("Can't find file " + this.location);
        }
        object2 = new byte[1024];
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read((byte[])object2)) > 0) {
            byteArrayOutputStream.write((byte[])object2, 0, n);
        }
        this.binaryDownloadedContent = byteArrayOutputStream.toByteArray();
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getReader() throws Exception {
        File file;
        if (this.reader != null) {
            if (this.downloadedContent == null) {
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[1024];
                try {
                    int n;
                    while ((n = this.reader.read(cArray)) != -1) {
                        stringBuffer.append(new String(cArray, 0, n));
                    }
                }
                finally {
                    this.reader.close();
                }
                this.downloadedContent = stringBuffer.toString();
            }
            if (this.downloadedContent != null) {
                this.reader = new StringReader(this.downloadedContent);
            }
            return this.reader;
        }
        if (this.locationURL != null) {
            return new InputStreamReader(this.locationURL.openStream());
        }
        if (this.location == null) {
            throw new Exception("Null schema location?");
        }
        if (this.location.indexOf("://") > -1) {
            this.location = this.location.replaceAll("%20", " ");
            this.locationURL = new URL(this.location);
            return new InputStreamReader(this.locationURL.openStream());
        }
        if (this.location.startsWith("file:")) {
            this.location = this.location.substring(5);
        }
        if ((file = new File(this.location)).exists()) {
            this.locationURL = file.toURI().toURL();
            return new FileReader(this.location);
        }
        if (this.documentLocation != null && (file = new File(new File(this.documentLocation).getParentFile(), this.location)).exists()) {
            this.locationURL = file.toURI().toURL();
            return new FileReader(file);
        }
        this.locationURL = ClassLoader.getSystemResource(this.location);
        if (this.locationURL != null) {
            try {
                return new InputStreamReader(this.locationURL.openStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.locationURL = new URL(new URL(this.documentLocation), this.location);
            return new InputStreamReader(this.locationURL.openStream());
        }
        catch (Exception exception) {
            throw new Exception("No reader found ?");
        }
    }
}

