/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.action.file;

import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.XMLAction;
import com.japisoft.xmlpad.toolkit.XMLFileData;
import com.japisoft.xmlpad.toolkit.XMLToolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class LoadAction
extends XMLAction {
    public static final String ID = LoadAction.class.getName();

    static XMLFileData getContentFromFileName(String string) throws Throwable {
        InputStream inputStream = null;
        if (string.indexOf("://") > -1) {
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
        } else {
            inputStream = new FileInputStream(string);
        }
        return XMLToolkit.getContentFromInputStream(inputStream, null);
    }

    public static void loadInBuffer(XMLContainer xMLContainer, String string) throws Throwable {
        XMLFileData xMLFileData = LoadAction.getContentFromFileName(string);
        xMLContainer.setCurrentDocumentLocation(string);
        xMLContainer.setText(xMLFileData.getContent());
        Debug.debug("Read with " + xMLFileData.getEncoding());
        xMLContainer.getDocumentInfo().setEncoding(xMLFileData.getEncoding());
    }

    public boolean notifyAction() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(this.container.getDocumentInfo().getFileFilter());
        if (this.container.getDocumentInfo().getWorkingDirectory() != null) {
            jFileChooser.setCurrentDirectory(new File(this.container.getDocumentInfo().getWorkingDirectory()));
        } else if (SharedProperties.DEFAULT_LOAD_DIRECTORY != null) {
            jFileChooser.setCurrentDirectory(new File(SharedProperties.DEFAULT_LOAD_DIRECTORY));
        }
        int n = jFileChooser.showOpenDialog(this.editor);
        if (n == 0) {
            boolean bl = this.editor.isEnabledRealTimeStructureChanged();
            this.editor.setEnabledRealTimeStructureChanged(false);
            String string = "" + jFileChooser.getSelectedFile();
            try {
                LoadAction.loadInBuffer(this.container, string);
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this.editor, throwable.getMessage(), "Error", 0);
                throwable.printStackTrace();
                return INVALID_ACTION;
            }
            this.editor.setEnabledRealTimeStructureChanged(bl);
            this.editor.notifyStructureChanged();
        }
        return VALID_ACTION;
    }
}

