/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.editor;

import com.japisoft.xmlform.Toolkit;
import com.japisoft.xmlform.designer.Factory;
import com.japisoft.xmlform.editor.EditorComponent;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.action.xml.FormatAction;
import com.japisoft.xmlpad.bookmark.BookmarkContext;
import java.io.File;
import java.io.StringReader;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;

public class FormEditor
extends JTabbedPane
implements IXMLPanel,
ChangeListener {
    private XMLContainer container = null;
    private Factory factory = null;
    private EditorComponent ec = null;
    boolean addNotifyOk = false;

    public FormEditor(Factory factory) {
        super(3);
        this.factory = factory;
        this.container = factory.buildNewContainer();
        this.addTab("Source Editor", new ImageIcon(this.getClass().getResource("document_edit.png")), this.container.getView());
        this.ec = new EditorComponent();
        this.addTab("Visual Editor", new ImageIcon(this.getClass().getResource("flash.png")), this.ec);
    }

    public void addNotify() {
        this.addNotifyOk = true;
        super.addNotify();
        this.addChangeListener(this);
        String string = this.container.getText();
        if (string.indexOf("/>") > -1) {
            this.setSelectedIndex(1);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeChangeListener(this);
        this.addNotifyOk = false;
    }

    public void dispose() {
        this.container.dispose();
    }

    public Action getAction(String string) {
        return null;
    }

    public XMLContainer getMainContainer() {
        return this.container;
    }

    public XMLContainer getSelectedContainer() {
        return null;
    }

    public BookmarkContext getBookmarkContext() {
        return null;
    }

    public Iterator getProperties() {
        return this.container.getProperties();
    }

    public Object getProperty(String string, Object object) {
        return this.container.getProperty(string, object);
    }

    public Object getProperty(String string) {
        return this.container.getProperty(string);
    }

    public XMLContainer getSubContainer(String string) {
        return this.container.getSubContainer(string);
    }

    public JComponent getView() {
        return this;
    }

    public void prepareToSave() {
        this.setSelectedIndex(0);
    }

    public void postLoad() {
        if (this.addNotifyOk) {
            this.removeChangeListener(this);
        }
        this.setSelectedIndex(1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FormEditor.this.resetVisualData();
            }
        });
        if (this.addNotifyOk) {
            this.addChangeListener(this);
        }
    }

    private void resetVisualData() {
        String string = this.container.getText();
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            boolean bl = false;
            if (string.indexOf("/>") == -1 && string.indexOf("</") == -1) {
                string = string + "<tmp/>";
                bl = true;
            }
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            if (!bl) {
                this.ec.loadDocument(this.container.getCurrentDocumentLocation(), document);
            } else {
                NodeList nodeList = document.getChildNodes();
                boolean bl2 = false;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    ProcessingInstruction processingInstruction;
                    Node node = nodeList.item(i);
                    if (!(node instanceof ProcessingInstruction) || !"xmlform".equalsIgnoreCase((processingInstruction = (ProcessingInstruction)node).getTarget())) continue;
                    bl2 = true;
                    String string2 = processingInstruction.getData();
                    File file = new File(string2 = Toolkit.trimQuote(string2));
                    if (file.exists()) {
                        this.ec.newDocument(string2);
                        break;
                    }
                    if (this.container.getCurrentDocumentLocation() != null) {
                        file = new File(new File(this.container.getCurrentDocumentLocation()).getParentFile(), string2);
                        if (file.exists()) {
                            this.ec.newDocument(file.toString());
                            break;
                        }
                        this.ec.newDocument(string2);
                        break;
                    }
                    this.ec.newDocument(string2);
                    break;
                }
                if (!bl2) {
                    this.setSelectedIndex(0);
                    this.factory.buildAndShowErrorDialog("Can't find the xmlform processing instruction ?");
                }
            }
        }
        catch (Exception exception) {
            this.factory.buildAndShowErrorDialog("Error found in the XML source => " + exception.getMessage() + "]");
            this.setSelectedIndex(0);
        }
    }

    public boolean reload() {
        return false;
    }

    public void setAutoDisposeMode(boolean bl) {
        this.container.setAutoDisposeMode(bl);
    }

    public void setDocumentInfo(XMLDocumentInfo xMLDocumentInfo) {
        this.container.setDocumentInfo(xMLDocumentInfo);
    }

    public void setProperty(String string, Object object) {
        this.container.setProperty(string, object);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.getSelectedIndex() == 1) {
            this.resetVisualData();
        } else {
            try {
                Document document = this.ec.getDocument();
                FormatAction formatAction = (FormatAction)ActionModel.getActionByName(ActionModel.FORMAT_ACTION);
                XMLContainer xMLContainer = formatAction.getXMLContainer();
                formatAction.setXMLContainer(this.container);
                formatAction.formatAction(document);
                formatAction.setXMLContainer(xMLContainer);
            }
            catch (Exception exception) {
                this.factory.buildAndShowErrorDialog("Can't generate the source [" + exception.getMessage() + "]");
            }
        }
    }
}

