/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.editor;

import com.japisoft.framework.app.toolkit.Toolkit;
import com.japisoft.framework.internationalization.Traductor;
import com.japisoft.framework.ui.FastLabel;
import com.japisoft.framework.xml.validator.ErrorValidationNode;
import com.japisoft.xmlform.editor.ErrorHighlighter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorValidationErrorsPanel
extends JPanel
implements ListSelectionListener {
    private ErrorHighlighter highlighter;
    private JTable table;

    public EditorValidationErrorsPanel(ErrorHighlighter errorHighlighter) {
        this.highlighter = errorHighlighter;
        this.initUI();
        this.setPreferredSize(new Dimension(0, this.table.getFontMetrics(this.table.getFont()).getHeight() * 6));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.table.getSelectionModel().removeListSelectionListener(this);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.table = new JTable();
        this.add(new JScrollPane(this.table));
        this.table.setDefaultRenderer(ErrorValidationNode.class, new CustomRenderer());
        this.table.getSelectionModel().setSelectionMode(0);
    }

    public void init(List<ErrorValidationNode> list) {
        this.table.setModel(new ErrorsTableModel(list));
        this.table.getColumnModel().getColumn(0).setMaxWidth(16);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ErrorValidationNode errorValidationNode = (ErrorValidationNode)this.table.getModel().getValueAt(listSelectionEvent.getFirstIndex(), 0);
        this.highlighter.highlight(errorValidationNode);
    }

    class CustomRenderer
    extends FastLabel
    implements TableCellRenderer {
        private Icon bugIcon = Toolkit.getImageIcon("images/bug_red16.png");

        CustomRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                this.setIcon(this.bugIcon);
                this.setText(null);
            } else {
                ErrorValidationNode errorValidationNode = (ErrorValidationNode)object;
                this.setText(errorValidationNode.getMessage());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ErrorsTableModel
    implements TableModel {
        private List<ErrorValidationNode> errors = null;

        ErrorsTableModel(List<ErrorValidationNode> list) {
            this.errors = list;
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return ErrorValidationNode.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 1) {
                if (this.errors.size() == 1) {
                    return Traductor.traduce("oneerror", "1 error");
                }
                return this.errors.size() + " " + Traductor.traduce("errors2", "errors");
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.errors.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.errors.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

