/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.xsd.instance;

import com.japisoft.fastparser.FastVector;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.xml.XMLFileData;
import com.japisoft.framework.xml.XMLToolkit;
import com.japisoft.framework.xml.xsd.instance.XSDBuildInstance;

public class XSDInstanceGenerator {
    public static String generateXMLInstance(String string, String string2) throws Throwable {
        XMLFileData xMLFileData = XMLToolkit.getContentFromURI(string2, null);
        String string3 = xMLFileData.getContent();
        Parser parser = new Parser();
        parser.setFlatView(true);
        parser.setContent(string3.toCharArray());
        parser.parse();
        SimpleNode simpleNode = (SimpleNode)parser.getDocument().getRoot();
        String string4 = simpleNode.getAttribute("targetNamespace");
        if (string4 != null) {
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                simpleNode.childAt(i).setApplicationObject(string4);
            }
        }
        XSDInstanceGenerator.resolveNamespaceReference(simpleNode);
        XSDInstanceGenerator.resolveIncludeRedefineImport(simpleNode, string2);
        StringBuffer stringBuffer = new StringBuffer();
        XSDBuildInstance xSDBuildInstance = new XSDBuildInstance();
        xSDBuildInstance.buildElement(stringBuffer, string, simpleNode, string2, true);
        return stringBuffer.toString();
    }

    private static String resetReferenceName(String string, SimpleNode simpleNode) {
        String string2;
        String string3;
        int n = string.lastIndexOf(":");
        if (n > -1 && (string3 = simpleNode.getNameSpaceDeclarationURI(string2 = string.substring(0, n))) != null) {
            return "{" + string3 + "}" + string.substring(n + 1);
        }
        return null;
    }

    private static void resolveNamespaceReference(SimpleNode simpleNode) {
        FastVector fastVector = simpleNode.getDocument().getFlatNodes();
        for (int i = 0; i < fastVector.size(); ++i) {
            String string;
            SimpleNode simpleNode2 = (SimpleNode)fastVector.get(i);
            if (simpleNode2.hasAttribute("base")) {
                string = XSDInstanceGenerator.resetReferenceName(simpleNode2.getAttribute("base"), simpleNode);
                if (string == null) continue;
                simpleNode2.setAttribute("base", string);
                continue;
            }
            if (simpleNode2.hasAttribute("ref")) {
                string = XSDInstanceGenerator.resetReferenceName(simpleNode2.getAttribute("ref"), simpleNode);
                if (string == null) continue;
                simpleNode2.setAttribute("ref", string);
                continue;
            }
            if (!simpleNode2.hasAttribute("type") || (string = XSDInstanceGenerator.resetReferenceName(simpleNode2.getAttribute("type"), simpleNode)) == null) continue;
            simpleNode2.setAttribute("type", string);
        }
    }

    private static void resolveIncludeRedefineImport(SimpleNode simpleNode, String string) throws Throwable {
        String string2 = simpleNode.getAttribute("targetNamespace");
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            if (simpleNode.childAt(i).matchContent("include")) {
                XSDInstanceGenerator.resolveInclude(string2, simpleNode.childAt(i), string);
                continue;
            }
            if (simpleNode.childAt(i).matchContent("redefine")) {
                XSDInstanceGenerator.resolveRedefine(string2, simpleNode.childAt(i), string);
                continue;
            }
            if (!simpleNode.childAt(i).matchContent("import")) continue;
            XSDInstanceGenerator.resolveImport(simpleNode.childAt(i), string);
        }
    }

    private static SimpleNode resolveSchemaLocation(SimpleNode simpleNode, String string) throws Throwable {
        String string2 = simpleNode.getAttribute("schemaLocation");
        if (string2 != null) {
            XMLFileData xMLFileData = XMLToolkit.getContentFromRelativeOrAbsoluteLocation(string2, string);
            Parser parser = new Parser();
            parser.setFlatView(true);
            parser.setContent(xMLFileData.getContent().toCharArray());
            parser.parse();
            SimpleNode simpleNode2 = (SimpleNode)parser.getDocument().getRoot();
            XSDInstanceGenerator.resolveNamespaceReference(simpleNode2);
            XSDInstanceGenerator.resolveIncludeRedefineImport(simpleNode2, xMLFileData.uri);
            return simpleNode2;
        }
        return null;
    }

    private static void resolveInclude(String string, SimpleNode simpleNode, String string2) throws Throwable {
        SimpleNode simpleNode2 = XSDInstanceGenerator.resolveSchemaLocation(simpleNode, string2);
        if (simpleNode2 != null) {
            SimpleNode simpleNode3 = simpleNode.getSimpleParent();
            for (int i = 0; i < simpleNode2.childCount(); ++i) {
                simpleNode2.childAt(i).setApplicationObject(string);
                simpleNode3.addChildNode(simpleNode2.childAt(i));
            }
        }
    }

    private static void resolveRedefine(String string, SimpleNode simpleNode, String string2) throws Throwable {
        SimpleNode simpleNode2 = XSDInstanceGenerator.resolveSchemaLocation(simpleNode, string2);
        if (simpleNode2 != null) {
            int n;
            SimpleNode simpleNode3 = simpleNode.getSimpleParent();
            for (n = 0; n < simpleNode2.childCount(); ++n) {
                simpleNode2.childAt(n).setApplicationObject(string);
                simpleNode3.addChildNode(simpleNode2.childAt(n));
            }
            for (n = 0; n < simpleNode.childCount(); ++n) {
                simpleNode.childAt(n).setApplicationObject("override");
                simpleNode3.insertChildNode(0, simpleNode.childAt(n));
            }
        }
    }

    private static void resolveImport(SimpleNode simpleNode, String string) throws Throwable {
        SimpleNode simpleNode2 = XSDInstanceGenerator.resolveSchemaLocation(simpleNode, string);
        if (simpleNode2 != null) {
            SimpleNode simpleNode3 = simpleNode.getSimpleParent();
            for (int i = 0; i < simpleNode2.childCount(); ++i) {
                simpleNode2.childAt(i).setApplicationObject(simpleNode2.getAttribute("targetNamespace"));
                simpleNode3.addChildNode(simpleNode2.childAt(i));
            }
        }
    }
}

