/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.refactors.elements.schema;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.xml.refactor.elements.AbstractRefactor;
import com.japisoft.framework.xml.refactor.elements.RefactorAction;
import com.japisoft.framework.xml.refactor.ui.RefactorTable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementRefactor
extends AbstractRefactor {
    public static String[] ACTIONS = new String[]{"(V1) RENAME TO (V2)", "DELETE (V1)"};

    public ElementRefactor() {
        super((short)1);
    }

    protected Node refactorIt(Node node, RefactorAction refactorAction) {
        Element element = (Element)node;
        if ("element".equals(element.getLocalName())) {
            if ("(V1) RENAME TO (V2)".equals(refactorAction.getAction())) {
                if (refactorAction.matchOldValue(element.getAttribute("name"))) {
                    element.setAttribute("name", refactorAction.getNewValue());
                } else if (refactorAction.matchOldValue(element.getAttribute("ref"))) {
                    element.setAttribute("ref", refactorAction.getNewValue());
                } else if (refactorAction.matchOldValue(element.getAttribute("substitutionGroup"))) {
                    element.setAttribute("substitutionGroup", refactorAction.getNewValue());
                }
            } else if ("DELETE (V1)".equals(refactorAction.getAction())) {
                if (refactorAction.matchOldValue(element.getAttribute("name"))) {
                    return null;
                }
                if (refactorAction.matchOldValue(element.getAttribute("ref"))) {
                    return null;
                }
                if (refactorAction.matchOldValue(element.getAttribute("substitutionGroup"))) {
                    element.removeAttribute("substitutionGroup");
                }
            }
        }
        return node;
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public String getName() {
        return "W3C Schema element";
    }

    public boolean isDefault() {
        return false;
    }

    public void initTable(RefactorTable refactorTable, SimpleNode simpleNode) {
        if (simpleNode.matchContent("element")) {
            if (simpleNode.hasAttribute("name")) {
                refactorTable.init(0, simpleNode.getAttribute("name"));
            } else {
                refactorTable.init(0, simpleNode.getAttribute("ref"));
            }
        }
    }
}

