/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.refactor2.elements.xslt;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.xml.refactor2.AbstractRefactor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VariableParamRefactor
extends AbstractRefactor {
    public boolean requireNewValue() {
        return true;
    }

    private String extractVariableName(SimpleNode simpleNode) {
        if (simpleNode.matchContent("variable") && simpleNode.hasAttribute("name")) {
            return simpleNode.getAttribute("name");
        }
        if (simpleNode.matchContent("param") && simpleNode.hasAttribute("name")) {
            return simpleNode.getAttribute("name");
        }
        if (simpleNode.matchContent("with-param") && simpleNode.hasAttribute("name")) {
            return simpleNode.getAttribute("name");
        }
        for (int i = 0; i < simpleNode.getViewAttributeCount(); ++i) {
            String string = simpleNode.getViewAttributeAt(i);
            String string2 = simpleNode.getAttribute(string);
            int n = string2.indexOf("$");
            if (n <= -1) continue;
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = n + 1; j < string2.length() && (Character.isLetterOrDigit(string2.charAt(j)) || string2.charAt(j) == '_'); ++j) {
                stringBuffer.append(string2.charAt(j));
            }
            if (stringBuffer.length() <= 0) continue;
            return stringBuffer.toString();
        }
        return null;
    }

    public String getTitle(SimpleNode simpleNode) {
        String string = this.extractVariableName(simpleNode);
        if (string != null) {
            return "The variable or parameter '" + string + "'";
        }
        return null;
    }

    public boolean process(SimpleNode simpleNode) {
        this.oldValue = this.extractVariableName(simpleNode);
        return this.oldValue != null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = false;
        if ("http://www.w3.org/1999/XSL/Transform".equals(string) && ("variable".equals(string2) || "param".equals(string2) || "with-param".equals(string2)) && this.oldValue.equals(attributes.getValue("name"))) {
            attributes = new AttributesProxy(attributes, true);
            bl = true;
        }
        if (!bl) {
            String string4 = "$" + this.oldValue;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getValue(i).contains(string4)) continue;
                attributes = new AttributesProxy(attributes, false);
            }
        }
        super.startElement(string, string2, string3, attributes);
    }

    class AttributesProxy
    implements Attributes {
        private Attributes ref;
        private boolean variableOrParam = false;

        AttributesProxy(Attributes attributes, boolean bl) {
            this.ref = attributes;
            this.variableOrParam = bl;
        }

        public int getIndex(String string, String string2) {
            return this.ref.getIndex(string, string2);
        }

        public int getIndex(String string) {
            return this.ref.getIndex(string);
        }

        public int getLength() {
            return this.ref.getLength();
        }

        public String getLocalName(int n) {
            return this.ref.getLocalName(n);
        }

        public String getQName(int n) {
            return this.ref.getQName(n);
        }

        public String getType(int n) {
            return this.ref.getType(n);
        }

        public String getType(String string, String string2) {
            return this.ref.getType(string, string2);
        }

        public String getType(String string) {
            return this.ref.getType(string);
        }

        public String getURI(int n) {
            return this.ref.getURI(n);
        }

        private String processValue(String string) {
            if (this.variableOrParam && string.equals(VariableParamRefactor.this.oldValue)) {
                return VariableParamRefactor.this.newValue;
            }
            if (!this.variableOrParam) {
                string = string.replaceAll("\\$" + VariableParamRefactor.this.oldValue, "\\$" + VariableParamRefactor.this.newValue);
            }
            return string;
        }

        public String getValue(int n) {
            return this.processValue(this.ref.getValue(n));
        }

        public String getValue(String string, String string2) {
            return this.processValue(this.ref.getValue(string, string2));
        }

        public String getValue(String string) {
            return this.processValue(this.ref.getValue(string));
        }
    }
}

