/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.ui.text;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class EmptyColoredTextField
extends JTextField {
    private Color emptyColor = null;
    private Color okColor = null;

    public EmptyColoredTextField(Color color, Color color2) {
        this.emptyColor = color;
        this.okColor = color2;
        this.updateColor();
        this.setDocument(new CustomPlainDocument());
    }

    public EmptyColoredTextField() {
        this.emptyColor = UIManager.getColor("EmptyColoredTextField.emptyColor");
        this.okColor = UIManager.getColor("EmptyColoredTextField.okColor");
        this.updateColor();
        this.setDocument(new CustomPlainDocument());
    }

    private void updateColor() {
        if (this.emptyColor == null || this.okColor == null) {
            return;
        }
        if (this.getDocument().getLength() == 0) {
            if (this.getBackground() != this.emptyColor) {
                this.setBackground(this.emptyColor);
            }
        } else if (this.getBackground() != this.okColor) {
            this.setBackground(this.okColor);
        }
    }

    class CustomPlainDocument
    extends PlainDocument {
        CustomPlainDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            EmptyColoredTextField.this.updateColor();
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            EmptyColoredTextField.this.updateColor();
        }
    }
}

