/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.spellchecker;

import com.japisoft.framework.spellchecker.Dictionnary;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class ErrorWordHighlight
implements DocumentListener {
    private JTextComponent component = null;
    private Dictionnary dictionnary = null;
    private HashMap map = null;

    public ErrorWordHighlight(JTextComponent jTextComponent, Dictionnary dictionnary) {
        this.component = jTextComponent;
        this.dictionnary = dictionnary;
        this.map = new HashMap();
        jTextComponent.getDocument().addDocumentListener(this);
    }

    public void dispose() {
        this.component.getDocument().removeDocumentListener(this);
        this.component = null;
        this.dictionnary = null;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkWords(documentEvent.getOffset(), documentEvent.getLength());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkWords(documentEvent.getOffset(), documentEvent.getLength());
    }

    private void checkWords(int n, int n2) {
        Document document = this.component.getDocument();
        Element element = document.getDefaultRootElement();
        int n3 = element.getElementIndex(n);
        int n4 = element.getElementIndex(n + n2);
        for (int i = n3; i <= n4; ++i) {
            Element element2 = element.getElement(i);
            int n5 = element2.getStartOffset();
            int n6 = element2.getEndOffset();
            try {
                String string = document.getText(n5, n6 - n5);
                this.checkWords(n5, string, i);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private void checkWords(int n, String string, int n2) {
        char c;
        List list = (List)this.map.get(new Integer(n2));
        if (list != null) {
            for (c = '\u0000'; c < list.size(); ++c) {
                Object e = list.get(c);
                this.component.getHighlighter().removeHighlight(e);
            }
            this.map.remove(new Integer(n2));
        }
        c = '\u0000';
        int n3 = -1;
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (Character.isLetter(c) || c == '\'') {
                if (n3 != -1) continue;
                n3 = i;
                continue;
            }
            if (n3 == -1) continue;
            String string2 = string.substring(n3, i);
            this.checkWord(n + n3, string2, n2);
            n3 = -1;
        }
    }

    private void checkWord(int n, String string, int n2) {
        if (!this.dictionnary.isValid(string)) {
            try {
                Object object = this.component.getHighlighter().addHighlight(n, n + string.length(), new CustomHighlighter());
                ArrayList<Object> arrayList = (ArrayList<Object>)this.map.get(new Integer(n2));
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    this.map.put(new Integer(n2), arrayList);
                }
                arrayList.add(object);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        JTextArea jTextArea = new JTextArea();
        JFrame jFrame = new JFrame();
        jFrame.add(new JScrollPane(jTextArea));
        jFrame.setSize(400, 400);
        URL uRL = ErrorWordHighlight.class.getResource("fr_FR.dic");
        URL uRL2 = ErrorWordHighlight.class.getResource("fr_FR.aff");
        new ErrorWordHighlight(jTextArea, new Dictionnary(uRL, uRL2));
        jFrame.setVisible(true);
    }

    class CustomHighlighter
    implements Highlighter.HighlightPainter {
        CustomHighlighter() {
        }

        private void paintDashedLine(Graphics graphics, int n, int n2, int n3) {
            graphics.setColor(Color.RED);
            for (int i = n; i < n3; i += 4) {
                graphics.drawLine(i, n2, i + 2, n2);
            }
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            try {
                Rectangle rectangle = jTextComponent.modelToView(n);
                Rectangle rectangle2 = jTextComponent.modelToView(n2);
                this.paintDashedLine(graphics, rectangle.x, rectangle.y + rectangle.height - 2, rectangle2.x);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

