/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xslt.action;

import com.japisoft.editix.ui.xslt.XSLTEditor;
import com.japisoft.framework.dialog.BasicOKCancelDialogComponent;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.ui.text.FileTextField;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.ActionModel;
import java.awt.event.ActionEvent;
import java.io.FileReader;
import java.io.FileWriter;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class RunAction
extends AbstractAction {
    private JFrame owner;
    private XSLTEditor container;
    private ResultDialog dialog = null;

    public RunAction(JFrame jFrame, XSLTEditor xSLTEditor) {
        this.owner = jFrame;
        this.container = xSLTEditor;
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("Play16.gif")));
        this.putValue("Name", "Run XSLT");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = this.container.getXSLTFile();
        String string3 = this.container.getDataFile();
        String string4 = string = this.dialog != null ? this.dialog.getFile() : null;
        if (string == null) {
            string = XSLTEditor.DEF_RESULTFile;
        }
        this.dialog = new ResultDialog(string);
        this.dialog.setVisible(true);
        if (this.dialog.getLastAction() == DialogManager.OK_ID) {
            String string5 = this.dialog.getFile();
            if (string2 == null || string2.length() == 0) {
                JOptionPane.showMessageDialog(this.container.getView(), "Save your XSLT File before transforming", "Error", 0);
                return;
            }
            if (string3 == null || string3.length() == 0) {
                JOptionPane.showMessageDialog(this.container.getView(), "No Data File", "Error", 0);
                return;
            }
            if (string5 == null || string5.length() == 0) {
                JOptionPane.showMessageDialog(this.container.getView(), "No Result File", "Error", 0);
                return;
            }
            ActionModel.activeActionByName(ActionModel.SAVE_ACTION);
            try {
                this.error(null);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer(new StreamSource(new FileReader(string2)));
                transformer.transform(new StreamSource(new FileReader(string3)), new StreamResult(new FileWriter(this.dialog.getFile())));
                this.container.setProperty("xslt.result.file", this.dialog.getFile());
                this.container.loadResultFile();
                XSLTEditor.DEF_DATAFile = string3;
                XSLTEditor.DEF_RESULTFile = this.dialog.getFile();
                XSLTEditor.DEF_XSLTFile = string2;
            }
            catch (TransformerException transformerException) {
                if ("true".equals(System.getProperty("editix.debug"))) {
                    transformerException.printStackTrace();
                }
                String string6 = transformerException.getMessage();
                Throwable throwable = transformerException;
                while (((Throwable)throwable).getCause() != null) {
                    throwable = ((Throwable)throwable).getCause();
                }
                string6 = throwable.getMessage();
                XMLContainer xMLContainer = this.container.getMainContainer();
                if (transformerException.getLocator() != null) {
                    xMLContainer.getErrorManager().notifyError(string6, transformerException.getLocator().getLineNumber());
                } else {
                    this.error(string6);
                }
            }
            catch (Throwable throwable) {
                if ("true".equals(System.getProperty("editix.debug"))) {
                    throwable.printStackTrace();
                }
                this.error(throwable.getMessage());
            }
        }
    }

    private void error(String string) {
        this.container.getMainContainer().getErrorManager().notifyError(string, 0);
    }

    class ResultDialog
    extends BasicOKCancelDialogComponent {
        FileTextField tft;

        public ResultDialog(String string) {
            super(RunAction.this.owner, "XSLT Result file", "XSLT Result file", "Choose a file for the transformation result", null);
            this.tft = null;
            this.tft = new FileTextField("Result", null, (String)null);
            if (string != null) {
                this.tft.setText(string);
            }
            this.setUI(this.tft);
            this.setSize(300, 200);
        }

        public String getFile() {
            return this.tft.getText();
        }
    }
}

