/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xslt;

import com.japisoft.editix.ui.xslt.SingleFactoryImpl;
import com.japisoft.editix.ui.xslt.XSLTEditor;
import com.japisoft.editix.ui.xslt.action.RunAction;
import com.japisoft.editix.ui.xslt.action.SyntaxCompletionAction;
import com.japisoft.framework.dialog.welcome.WelcomeDialog;
import com.japisoft.xmlpad.UIStateListener;
import com.japisoft.xmlpad.action.ActionGroup;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.action.file.LoadAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JToolBar;

public class XSLTContainerLauncher
extends JFrame
implements WindowListener,
UIStateListener {
    static int height = 15;
    static XSLTContainerLauncher cl = null;
    public static String CONTEXT = "nbxslt";
    public static String CONTEXT_TITLE = "Netbeans - XSLT Editor";
    private XSLTEditor container;
    private boolean delayedResetContent = false;
    String template = null;
    private boolean ok = false;

    public XSLTContainerLauncher(String string) {
        super(string == null ? "XSLT Editor : http://www.editix.com" : "XML Editor : http://www.editix.com");
        this.setSize(800, 640 - 2 * height);
        this.initUI();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeConfig(XSLTContainerLauncher xSLTContainerLauncher) {
        File file = new File(System.getProperty("user.home"), "." + CONTEXT);
        if (!file.exists()) {
            file.mkdir();
        }
        try {
            Object object;
            FileWriter fileWriter = new FileWriter(new File(file, "config"));
            try {
                object = xSLTContainerLauncher.getBounds();
                fileWriter.write(((Rectangle)object).x + "," + ((Rectangle)object).y + "," + ((Rectangle)object).width + "," + ((Rectangle)object).height);
            }
            finally {
                fileWriter.close();
            }
            object = new FileWriter(new File(file, "xslt.param"));
            try {
                ((Writer)object).write(XSLTEditor.DEF_XSLTFile == null ? "-" : XSLTEditor.DEF_XSLTFile);
                ((Writer)object).write("\n");
                ((Writer)object).write(XSLTEditor.DEF_DATAFile == null ? "-" : XSLTEditor.DEF_DATAFile);
                ((Writer)object).write("\n");
                ((Writer)object).write(XSLTEditor.DEF_RESULTFile == null ? "-" : XSLTEditor.DEF_RESULTFile);
            }
            finally {
                ((OutputStreamWriter)object).close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreConfig(XSLTContainerLauncher xSLTContainerLauncher, File file) {
        xSLTContainerLauncher.delayedResetContent = false;
        File file2 = new File(System.getProperty("user.home"), "." + CONTEXT);
        try {
            String string;
            BufferedReader bufferedReader;
            String string2 = null;
            File file3 = new File(file2, "config");
            if (file3.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file3));
                try {
                    string = bufferedReader.readLine();
                    if (string != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                        Rectangle rectangle = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                        xSLTContainerLauncher.setBounds(rectangle);
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            if ((file3 = new File(file2, "xslt.param")).exists()) {
                bufferedReader = new BufferedReader(new FileReader(file3));
                try {
                    string = bufferedReader.readLine();
                    if (!"-".equals(string)) {
                        string2 = string;
                    }
                    if (!"-".equals(string = bufferedReader.readLine())) {
                        XSLTEditor.DEF_DATAFile = string;
                    }
                    if (!"-".equals(string = bufferedReader.readLine())) {
                        XSLTEditor.DEF_RESULTFile = string;
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            if (file != null) {
                if (file.length() == 0L) {
                    XSLTEditor.DEF_XSLTFile = null;
                    xSLTContainerLauncher.resetContent();
                    return;
                }
                string2 = file.toString();
            }
            if (string2 != null) {
                XSLTEditor.DEF_XSLTFile = string2;
            } else {
                xSLTContainerLauncher.resetContent();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void showUI() {
        XSLTContainerLauncher.showUI(CONTEXT_TITLE, null, null);
    }

    public static void showUI(String string, File file, String string2) {
        if (cl == null) {
            cl = new XSLTContainerLauncher(string2);
        }
        cl.prepareDocumentType(string2);
        XSLTContainerLauncher.restoreConfig(cl, file);
        cl.setVisible(true);
        cl.toFront();
        WelcomeDialog.showDialog(cl.getOwner(), "http://www.japisoft.com. This tool uses JXMLPad : http://www.jxmlpad.com and JDock a swing docking framework : http://www.swingall.com", string, new String[]{"JDock is a swing docking framework working with any layouts : http://www.swingall.com", "Need a swing component ? : Look at http://www.swingall.com", "Use JXMLPad inside your swing application for editing any XML documents : http://www.jxmlpad.com", "Do you want an XSLT Debugger ? Look at EditiX : http://www.editix.com", "Do you want to generate a schema, a DTD ? Look at EditiX : http://www.editix.com", "Do you want to use RelaxNG ? Look at EditiX : http://www.editix.com", "XML Diff ? Look at EditiX : http://www.editix.com", "Do you want an Applet for editing your XML document : http://www.jxmlpad.com", "JXMLPad is a swing based component for editing your XML documents. JXMLPad supports W3C XML Schema, DTD or XML RelaxNG. http://www.jxmlpad.com", "Evaluate your math expressions with JFormula 3.0 : http://www.japisoft/formula", "Evaluate your boolean expressions with JFormula 3.0 : http://www.japisoft/formula", "Plug your function, symbol and operators with JFormula 3.0 : http://www.japisoft.com/formula"}, null);
    }

    public void ready() {
        if (this.delayedResetContent) {
            this.resetDocument();
        } else {
            if (XSLTEditor.DEF_XSLTFile != null) {
                try {
                    LoadAction.loadInBuffer(this.container.getMainContainer(), XSLTEditor.DEF_XSLTFile);
                    this.container.getMainContainer().getDocumentInfo().setCurrentDocumentLocation(XSLTEditor.DEF_XSLTFile.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (XSLTEditor.DEF_DATAFile != null) {
                this.container.loadDataFile(XSLTEditor.DEF_DATAFile);
            }
        }
        this.delayedResetContent = false;
    }

    public void dispose() {
        this.delayedResetContent = false;
    }

    private void resetContent() {
        this.delayedResetContent = true;
    }

    private void resetDTD(String string, String string2) {
        URL uRL = this.getClass().getResource(string2);
        if (uRL == null) {
            uRL = ClassLoader.getSystemClassLoader().getResource("com/japisoft/editix/ui/xslt/" + string2);
        }
        if (uRL != null) {
            this.container.getMainContainer().getSchemaAccessibility().setDefaultDTD(string, uRL);
        }
    }

    private void prepareDocumentType(String string) {
        if (string == null) {
            this.container.getMainContainer().getDocumentInfo().setDefaultFileExt("xsl");
            this.container.getMainContainer().getDocumentColorAccessibility().setColorForPrefix("xsl", Color.green.darker());
            this.container.getMainContainer().getDocumentColorAccessibility().setColorForPrefix("xs", Color.green.darker());
            this.resetDTD("xsl:stylesheet", "xslt.dtd");
            String string2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
            string2 = string2 + "<xsl:stylesheet version=\"1.0\"";
            string2 = string2 + " xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n";
            string2 = string2 + "xmlns=\"http://www.w3.org/TR/xhtml1/strict\">\n";
            string2 = string2 + "<xsl:output method=\"html\"/>\n";
            string2 = string2 + "<xsl:template match=\"/\">\n";
            string2 = string2 + " <html>\n";
            string2 = string2 + "   <body>\n";
            string2 = string2 + "   </body>\n";
            string2 = string2 + "  </html>\n";
            string2 = string2 + " </xsl:template>\n";
            this.template = string2 = string2 + "</xsl:stylesheet>\n";
        } else {
            this.template = null;
            if ("ant".equals(string)) {
                this.resetDTD("project", "ant.dtd");
            } else if ("xsd".equals(string)) {
                this.resetDTD("xsd:schema", "XMLSchema.dtd");
                this.template = " <?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n</xsd:schema>";
            }
            this.container.getMainContainer().getSchemaAccessibility().setDefaultDTD(null, (String)null);
            if (this.template == null) {
                this.template = "<?xml version=\"1.0\"?>\n\n";
            }
        }
    }

    private void resetDocument() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        string = string + "<xsl:stylesheet version=\"1.0\"";
        string = string + " xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n";
        string = string + "xmlns=\"http://www.w3.org/TR/xhtml1/strict\">\n";
        string = string + "<xsl:output method=\"html\"/>\n";
        string = string + "<xsl:template match=\"/\">\n";
        string = string + " <html>\n";
        string = string + "   <body>\n";
        string = string + "   </body>\n";
        string = string + "  </html>\n";
        string = string + " </xsl:template>\n";
        string = string + "</xsl:stylesheet>\n";
        this.container.getMainContainer().getAccessibility().setText(this.template);
    }

    private void initUI() {
        this.getContentPane().setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        this.getContentPane().add((Component)jToolBar, "North");
        ActionModel.removeActionByName(ActionModel.NEW_ACTION);
        this.container = new XSLTEditor(null, new SingleFactoryImpl(), false);
        if (ActionModel.getGroupByName("XSLT") == null) {
            ActionGroup actionGroup = new ActionGroup("XSLT");
            ActionModel.addGroup(actionGroup);
            actionGroup.addAction(new SyntaxCompletionAction(this.container.getMainContainer()));
            actionGroup.addAction(new RunAction(this, this.container));
        }
        ActionModel.buildToolBar(jToolBar);
        this.getContentPane().add((Component)this.container.getView(), "Center");
        ActionModel.resetActionState(this.container.getMainContainer());
        ActionModel.setEnabledAutoResetActionState(false);
        ActionModel.setEnabledAction(ActionModel.LOAD_ACTION, true);
        ActionModel.setEnabledAction(ActionModel.FORMAT_ACTION, true);
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (!this.ok) {
            this.ready();
        }
        this.ok = true;
    }

    public void windowClosed(WindowEvent windowEvent) {
        XSLTContainerLauncher.storeConfig(this);
        this.dispose();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
        this.ok = false;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        XSLTContainerLauncher.showUI();
    }
}

