/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xslt;

import com.japisoft.editix.ui.xslt.LineSelectionListener;
import com.japisoft.editix.ui.xslt.profiler.ProfilerElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class ProfilerContainer
extends JPanel
implements ListSelectionListener {
    private LineSelectionListener container;
    private JTable table = null;
    private NodeRenderer nr = new NodeRenderer();

    public ProfilerContainer(LineSelectionListener lineSelectionListener) {
        this.initUI();
        this.container = lineSelectionListener;
    }

    private void initUI() {
        this.table = new JTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public TableCellRenderer getCellRenderer(int n, int n2) {
                return ProfilerContainer.this.nr;
            }
        };
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{"Node", "Time", "Iter"}, 0);
        this.table.setModel(defaultTableModel);
        this.table.getSelectionModel().setSelectionMode(0);
        this.updateTableColumnSize();
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.table));
    }

    private void updateTableColumnSize() {
        this.table.getColumnModel().getColumn(0).setWidth(150);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setMaxWidth(30);
    }

    public void addNotify() {
        super.addNotify();
        this.linkListeners();
    }

    public void removeNotify() {
        super.removeNotify();
        this.unlinkListners();
    }

    private void linkListeners() {
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    private void unlinkListners() {
        this.table.getSelectionModel().removeListSelectionListener(this);
    }

    public void updateProfilerContext(ArrayList arrayList) {
        this.unlinkListners();
        double d = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            ProfilerElement profilerElement = (ProfilerElement)arrayList.get(i);
            d += profilerElement.totalTime;
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{"Node", "Time", "Iter"}, 0);
        for (int i = 0; i < arrayList.size(); ++i) {
            ProfilerElement profilerElement = (ProfilerElement)arrayList.get(i);
            profilerElement.timePercent = (int)Math.round(profilerElement.totalTime / d * 100.0);
            defaultTableModel.addRow(new Object[]{profilerElement, profilerElement, profilerElement});
        }
        this.table.setModel(defaultTableModel);
        this.updateTableColumnSize();
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.linkListeners();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getFirstIndex() > -1) {
            ProfilerElement profilerElement = (ProfilerElement)this.table.getModel().getValueAt(listSelectionEvent.getFirstIndex(), 0);
            this.container.showXSLTLine(profilerElement.uri, profilerElement.line);
        }
    }

    class NodeRenderer
    implements TableCellRenderer {
        private JLabel label = new JLabel();
        private JProgressBar bar = new JProgressBar();

        private NodeRenderer() {
            this.label.setOpaque(true);
            this.bar.setForeground(new Color(200, 250, 200));
            this.bar.setMinimum(0);
            this.bar.setMaximum(100);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.label.setForeground(jTable.getSelectionForeground());
                this.label.setBackground(jTable.getSelectionBackground());
                this.bar.setBackground(jTable.getSelectionBackground());
            } else {
                this.label.setForeground(jTable.getForeground());
                this.label.setBackground(jTable.getBackground());
                this.bar.setBackground(jTable.getBackground());
            }
            ProfilerElement profilerElement = (ProfilerElement)object;
            if (n2 == 1) {
                this.bar.setValue(profilerElement.timePercent);
                return this.bar;
            }
            if (n2 == 0) {
                this.label.setHorizontalAlignment(2);
                this.label.setText(profilerElement.name);
            } else if (n2 == 2) {
                this.label.setHorizontalAlignment(0);
                this.label.setText("" + profilerElement.iteration);
            }
            return this.label;
        }
    }
}

