/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui;

import com.japisoft.editix.ui.EditixNodeLocationListener;
import com.japisoft.fastparser.node.SimpleNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class EditixNodeLocationBar
extends JComponent
implements MouseListener,
MouseMotionListener {
    private List<SimpleNode> hierarchy = null;
    private static Color LIGHT = new Color(250, 250, 250);
    private static Color LIGHT2 = new Color(240, 240, 240);
    private static Color DARK = new Color(140, 140, 140);
    private EditixNodeLocationListener listener;
    private FontMetrics fm = null;
    private int currentSelection = -1;
    private int currentMouseX = -1;
    private int currentMouseY = -1;

    public EditixNodeLocationBar(EditixNodeLocationListener editixNodeLocationListener) {
        this.setPreferredSize(new Dimension(0, 16));
        this.listener = editixNodeLocationListener;
        this.setBorder(null);
    }

    public void addNotify() {
        super.addNotify();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void setCurrentNode(SimpleNode simpleNode) {
        if (this.hierarchy == null) {
            if (simpleNode != null) {
                this.hierarchy = new ArrayList<SimpleNode>();
            }
        } else {
            this.hierarchy.removeAll(this.hierarchy);
        }
        while (simpleNode != null) {
            this.hierarchy.add(0, simpleNode);
            simpleNode = simpleNode.getSimpleParent();
        }
        this.repaint();
    }

    private void drawHierarchy(Graphics graphics) {
        if (this.hierarchy != null && this.hierarchy.size() > 0) {
            int n = this.getWidth() / this.hierarchy.size();
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            for (int i = 0; i < this.hierarchy.size(); ++i) {
                SimpleNode simpleNode = this.hierarchy.get(i);
                Rectangle rectangle = new Rectangle(n2 + 1, 1, n - 1, this.getHeight() - 2);
                if (i == this.hierarchy.size() - 1) {
                    graphics.setColor(LIGHT2);
                } else {
                    graphics.setColor(LIGHT);
                }
                bl = false;
                if (this.currentMouseX > 0 && this.currentMouseY > 0 && rectangle.contains(this.currentMouseX, this.currentMouseY)) {
                    if (this.currentSelection != n3) {
                        this.setToolTipText(simpleNode.getXPathLocation());
                    }
                    this.currentSelection = n3;
                    graphics.setColor(UIManager.getColor("List.selectionBackground"));
                    bl = true;
                }
                graphics.fill3DRect(rectangle.x + 1, rectangle.y, rectangle.width - 2, rectangle.height, true);
                String string = simpleNode.getContent();
                int n4 = this.fm.stringWidth(string);
                if (n4 > n) {
                    double d = (double)n / (double)n4;
                    int n5 = (int)((double)string.length() * d);
                    string = n5 > 0 ? string.substring(0, n5) : "";
                }
                int n6 = this.getHeight() - this.fm.getDescent();
                if (!bl) {
                    graphics.setColor(DARK);
                } else {
                    graphics.setColor(UIManager.getColor("List.selectionForeground"));
                }
                graphics.drawString(string, n2 + 2, n6);
                n2 += n;
                ++n3;
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.fm == null) {
            this.fm = this.getFontMetrics(this.getFont());
        }
        this.drawHierarchy(graphics);
    }

    public void dispose() {
        this.hierarchy = null;
        this.listener = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.hierarchy != null && this.hierarchy.size() > 0) {
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            this.repaint();
        } else {
            this.currentMouseX = -1;
            this.currentMouseY = -1;
            this.currentSelection = -1;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.currentSelection >= 0) {
            this.listener.gotoNode(this.hierarchy.get(this.currentSelection));
        }
    }

    private SimpleNode getCurrentSelection() {
        if (this.currentSelection >= 0) {
            return this.hierarchy.get(this.currentSelection);
        }
        return null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.currentMouseX = -1;
        this.currentMouseY = -1;
        this.currentSelection = -1;
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            CustomPopupMenu customPopupMenu = new CustomPopupMenu();
            customPopupMenu.show(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    class CustomPopupMenu
    extends JPopupMenu
    implements ActionListener {
        private SimpleNode currentNode = null;

        CustomPopupMenu() {
        }

        public void show(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JMenuItem jMenuItem = new JMenuItem("Go to");
                jMenuItem.setActionCommand("goto");
                jMenuItem.addActionListener(this);
                this.add(jMenuItem);
                this.addSeparator();
                jMenuItem = new JMenuItem("Select");
                jMenuItem.addActionListener(this);
                jMenuItem.setActionCommand("select");
                this.add(jMenuItem);
                jMenuItem = new JMenuItem("Copy");
                jMenuItem.setActionCommand("copy");
                jMenuItem.addActionListener(this);
                this.add(jMenuItem);
                jMenuItem = new JMenuItem("Cut");
                jMenuItem.setActionCommand("cut");
                jMenuItem.addActionListener(this);
                this.add(jMenuItem);
                this.currentNode = EditixNodeLocationBar.this.getCurrentSelection();
                this.show(EditixNodeLocationBar.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void hide() {
            super.hide();
            this.currentNode = null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("goto".equals(string)) {
                EditixNodeLocationBar.this.listener.gotoNode(this.currentNode);
            } else if ("select".equals(string)) {
                EditixNodeLocationBar.this.listener.selectNode(this.currentNode);
            } else if ("copy".equals(string)) {
                EditixNodeLocationBar.this.listener.copyNode(this.currentNode);
            } else if ("cut".equals(string)) {
                EditixNodeLocationBar.this.listener.cutNode(this.currentNode);
            }
            this.currentNode = null;
        }
    }
}

