/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db.ui;

import com.japisoft.editix.db.Driver;
import com.japisoft.editix.db.DriverDbManager;
import com.japisoft.editix.db.xmldb.XmlDbDriver;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.framework.ui.toolkit.FileManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;

public class DbDriverConfigPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private Driver currentDriver = null;
    private JButton addDriver;
    private JButton addJar;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JList listDrivers;
    private JList listJars;
    private JButton removeDriver;
    private JButton removeJar;
    private JTextField txtDefaultUrl;
    private JTextField txtDriverClass;

    public DbDriverConfigPanel() {
        this.initComponents();
        this.resetListDrivers();
    }

    private void resetListDrivers() {
        DefaultListModel<Driver> defaultListModel = new DefaultListModel<Driver>();
        for (int i = 0; i < DriverDbManager.getDriverCount(); ++i) {
            defaultListModel.addElement(DriverDbManager.getDriver(i));
        }
        this.listDrivers.setModel(defaultListModel);
    }

    public void addNotify() {
        super.addNotify();
        this.addDriver.addActionListener(this);
        this.removeDriver.addActionListener(this);
        this.addJar.addActionListener(this);
        this.removeJar.addActionListener(this);
        this.listDrivers.getSelectionModel().addListSelectionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.addDriver.removeActionListener(this);
        this.removeDriver.removeActionListener(this);
        this.addJar.removeActionListener(this);
        this.removeJar.removeActionListener(this);
        this.listDrivers.getSelectionModel().removeListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Driver driver = (Driver)this.listDrivers.getSelectedValue();
        this.resetDriver(driver);
    }

    private void resetDriver(Driver driver) {
        String[] stringArray;
        if (this.currentDriver != null) {
            this.synchroDriver(this.currentDriver);
        }
        this.removeDriver.setEnabled(!driver.system);
        this.txtDefaultUrl.setText(driver.url);
        this.txtDriverClass.setText(driver.dbxmlClass);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        String string = driver.jars;
        if (string != null && (stringArray = string.split(";")) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                defaultListModel.addElement(stringArray[i]);
            }
        }
        this.listJars.setModel(defaultListModel);
        this.currentDriver = driver;
    }

    public void saveConfig() {
        if (this.currentDriver != null) {
            this.synchroDriver(this.currentDriver);
        }
        DriverDbManager.save();
    }

    private void synchroDriver(Driver driver) {
        driver.url = this.txtDefaultUrl.getText();
        driver.dbxmlClass = this.txtDriverClass.getText();
        ListModel listModel = this.listJars.getModel();
        String string = null;
        for (int i = 0; i < listModel.getSize(); ++i) {
            string = string == null ? (String)listModel.getElementAt(i) : string + ";" + (String)listModel.getElementAt(i);
        }
        driver.jars = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addDriver) {
            String string = EditixFactory.buildAndShowInputDialog("Driver name");
            if (string != null) {
                XmlDbDriver xmlDbDriver = new XmlDbDriver(string);
                DriverDbManager.addDriver(xmlDbDriver);
                this.resetListDrivers();
                ListModel listModel = this.listDrivers.getModel();
                this.listDrivers.getSelectionModel().setSelectionInterval(listModel.getSize() - 1, listModel.getSize() - 1);
            }
        } else if (actionEvent.getSource() == this.removeDriver) {
            DriverDbManager.removeDriver((Driver)this.listDrivers.getSelectedValue());
            this.resetListDrivers();
        } else if (actionEvent.getSource() == this.addJar) {
            File file = FileManager.getSelectedFile(true, "jar", "Jar file");
            if (file != null) {
                ((DefaultListModel)this.listJars.getModel()).addElement(file.toString());
            }
        } else if (actionEvent.getSource() == this.removeJar) {
            if (this.listJars.getSelectedValue() != null) {
                ((DefaultListModel)this.listJars.getModel()).removeElement(this.listJars.getSelectedValue());
            } else {
                EditixFactory.buildAndShowWarningDialog("No selected value");
            }
        }
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.txtDriverClass = new JTextField();
        this.jLabel2 = new JLabel();
        this.txtDefaultUrl = new JTextField();
        this.jPanel1 = new JPanel();
        this.addJar = new JButton();
        this.removeJar = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.listJars = new JList();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.listDrivers = new JList();
        this.addDriver = new JButton();
        this.removeDriver = new JButton();
        this.jLabel1.setText("XmlDb Driver class");
        this.txtDriverClass.setToolTipText("The XMLDb driver java class");
        this.jLabel2.setText("Default URL");
        this.txtDefaultUrl.setToolTipText("The default URL when activating a connection");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("External Jars"));
        this.addJar.setText("Add...");
        this.addJar.setToolTipText("Add a library as a jar file");
        this.removeJar.setText("Remove");
        this.removeJar.setToolTipText("Remove a library");
        this.jScrollPane2.setViewportView(this.listJars);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 194, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.addJar).add((Component)this.removeJar)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.addJar).addPreferredGap(0).add((Component)this.removeJar).add(59, 59, 59)).add((Component)this.jScrollPane2, -1, 122, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Drivers"));
        this.jScrollPane1.setViewportView(this.listDrivers);
        this.addDriver.setText("Add...");
        this.addDriver.setToolTipText("Add a new xmldb Driver");
        this.removeDriver.setText("Remove");
        this.removeDriver.setToolTipText("Remove the selected driver");
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jScrollPane1, -1, 204, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.addDriver).add((Component)this.removeDriver))));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.addDriver).addPreferredGap(0).add((Component)this.removeDriver).add(77, 77, 77)).add((Component)this.jScrollPane1, -1, 129, Short.MAX_VALUE));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 297, Short.MAX_VALUE).add(1, (Component)this.jLabel1).add(1, (Component)this.txtDriverClass, -1, 297, Short.MAX_VALUE).add(1, (Component)this.jLabel2).add(1, (Component)this.txtDefaultUrl, -1, 297, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.txtDriverClass, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.txtDefaultUrl, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

