/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.fop;

import com.japisoft.editix.ui.EditixDialog;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.ui.text.FileTextField;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class FOPDialog
extends EditixDialog
implements ActionListener {
    JLabel lblRenderer = new JLabel();
    JComboBox cbRenderer = new JComboBox();
    FileTextField fileSelector = new FileTextField("Output", null, (String[])null);
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JCheckBox cbExternalProg = null;

    public FOPDialog() {
        super("FOP", "FOP usage", "Transform your FO document to multiple outputs. Choose an output file and save it inside a project for reusing it the next time");
        this.jbInit();
        this.cbRenderer.setModel(new DefaultComboBoxModel<String>(new String[]{"PDF", "MIF", "PRINT", "PCL", "PS", "TXT", "RTF", "SVG"}));
    }

    protected Dimension getDefaultSize() {
        return new Dimension(350, 250);
    }

    private void jbInit() {
        this.lblRenderer.setText("Renderer type");
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.setLocale(Locale.getDefault());
        this.getContentPane().add((Component)this.lblRenderer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 6, 0, 153), 30, 0));
        this.getContentPane().add((Component)this.cbRenderer, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(7, 6, 0, 0), 207, 0));
        this.getContentPane().add((Component)this.fileSelector, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(7, 6, 64, 0), 235, 0));
        if (ApplicationModel.isWindowsPlatform()) {
            this.cbExternalProg = new JCheckBox("Display with an external program");
            this.getContentPane().add((Component)this.cbExternalProg, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(7, 6, 64, 0), 0, 0));
        }
    }

    public void beforeShowing() {
        super.beforeShowing();
        this.cbRenderer.addActionListener(this);
    }

    public void beforeClosing() {
        super.beforeClosing();
        this.cbRenderer.removeActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cbRenderer) {
            this.checkSelection();
        }
    }

    public void resetFile() {
    }

    private void checkSelection() {
        this.fileSelector.setEnabled(this.cbRenderer.getSelectedIndex() != 1 && this.cbRenderer.getSelectedIndex() != 3);
        if ("PDF".equals(this.cbRenderer.getSelectedItem())) {
            this.fileSelector.setFileExt("pdf");
        } else if ("PS".equals(this.cbRenderer.getSelectedItem())) {
            this.fileSelector.setFileExt("ps");
        } else if ("RTF".equals(this.cbRenderer.getSelectedItem())) {
            this.fileSelector.setFileExt("rtf");
        } else if ("TXT".equals(this.cbRenderer.getSelectedItem())) {
            this.fileSelector.setFileExt("txt");
        } else if ("SVG".equals(this.cbRenderer.getSelectedItem())) {
            this.fileSelector.setFileExt("svg");
        } else {
            this.fileSelector.setFileExt((String[])null);
        }
    }

    private String getFileExtension() {
        if ("PDF".equals(this.cbRenderer.getSelectedItem())) {
            return ".pdf";
        }
        if ("PS".equals(this.cbRenderer.getSelectedItem())) {
            return ".ps";
        }
        if ("RTF".equals(this.cbRenderer.getSelectedItem())) {
            return ".rtf";
        }
        if ("TXT".equals(this.cbRenderer.getSelectedItem())) {
            return ".txt";
        }
        if ("SVG".equals(this.cbRenderer.getSelectedItem())) {
            return ".svg";
        }
        return "";
    }

    public void init(XMLContainer xMLContainer) {
        this.cbRenderer.setSelectedItem(xMLContainer.getProperty("fo.render", "PDF"));
        this.fileSelector.setFilePath("" + xMLContainer.getProperty("fo.output", ""));
        if (this.cbExternalProg != null) {
            this.cbExternalProg.setSelected("true".equals(xMLContainer.getProperty("fo.viewer", "false")));
        }
        this.checkSelection();
    }

    public void store(XMLContainer xMLContainer) {
        xMLContainer.setProperty("fo.render", this.cbRenderer.getSelectedItem());
        xMLContainer.setProperty("fo.ok", "true");
        if (this.fileSelector.isEnabled()) {
            int n;
            Object object;
            String string;
            String string2 = this.fileSelector.getText();
            if (string2 != null && string2.indexOf(47) == -1 && string2.indexOf(92) == -1 && (string = xMLContainer.getCurrentDocumentLocation()) != null) {
                try {
                    object = new File(new File(string).getParentFile(), string2);
                    string2 = ((File)object).toString();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if ((n = string2.lastIndexOf(47)) == -1) {
                n = string2.lastIndexOf(92);
            }
            object = null;
            object = n == -1 ? string2 : string2.substring(n + 1);
            if (((String)object).indexOf(46) == -1) {
                string2 = string2 + this.getFileExtension();
            }
            xMLContainer.setProperty("fo.output", string2);
        } else {
            xMLContainer.setProperty("fo.output", "");
        }
        if (this.cbExternalProg != null) {
            xMLContainer.setProperty("fo.viewer", "" + this.cbExternalProg.isSelected());
        }
    }
}

