/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.exist.util.FastStringBuffer;
import org.exist.util.FloatingPointConverter;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.OrderedDurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;
import org.exist.xquery.value.YearMonthDurationValue;

public class DayTimeDurationValue
extends OrderedDurationValue {
    public static final Duration CANONICAL_ZERO_DURATION = TimeUtils.getInstance().newDuration(true, null, null, null, null, null, ZERO_DECIMAL);

    DayTimeDurationValue(Duration duration) throws XPathException {
        super(duration);
        if (duration.isSet(DatatypeConstants.YEARS) || duration.isSet(DatatypeConstants.MONTHS)) {
            throw new XPathException("the value '" + duration + "' is not an xdt:dayTimeDuration since it specifies year or month values");
        }
    }

    public DayTimeDurationValue(long millis) throws XPathException {
        this(TimeUtils.getInstance().newDurationDayTime(millis));
    }

    public DayTimeDurationValue(String str) throws XPathException {
        this(DayTimeDurationValue.createDurationDayTime(StringValue.trimWhitespace(str)));
    }

    private static Duration createDurationDayTime(String str) throws XPathException {
        try {
            return TimeUtils.getInstance().newDurationDayTime(str);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException("FORG0001: cannot construct " + Type.getTypeName(55) + " from \"" + str + "\"");
        }
    }

    public int getType() {
        return 55;
    }

    public double getValue() {
        double value = this.duration.getDays();
        value = value * 24.0 + (double)this.duration.getHours();
        value = value * 60.0 + (double)this.duration.getMinutes();
        Number n = this.duration.getField(DatatypeConstants.SECONDS);
        value = value * 60.0 + (n == null ? 0.0 : n.doubleValue());
        return value * (double)this.duration.getSign();
    }

    public long getValueInMilliseconds() {
        return (long)(this.getValue() * 1000.0);
    }

    protected Duration canonicalZeroDuration() {
        return CANONICAL_ZERO_DURATION;
    }

    public String getStringValue() {
        int d = this.duration.getDays();
        int h = this.duration.getHours();
        int m = this.duration.getMinutes();
        Number s = this.duration.getField(DatatypeConstants.SECONDS);
        if (s == null) {
            s = new Integer(0);
        }
        FastStringBuffer sb = new FastStringBuffer(32);
        if (this.duration.getSign() < 0) {
            sb.append('-');
        }
        sb.append('P');
        if (d != 0) {
            sb.append(d + "D");
        }
        if (d == 0 || h != 0 || m != 0 || s.intValue() != 0) {
            sb.append('T');
        }
        if (h != 0) {
            sb.append(h + "H");
        }
        if (m != 0) {
            sb.append(m + "M");
        }
        if (s.intValue() != 0 || d == 0 && m == 0 && h == 0) {
            FloatingPointConverter.appendFloat(sb, s.floatValue()).getNormalizedString(0);
            sb.append("S");
        }
        return sb.toString();
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 55: {
                return new DayTimeDurationValue(this.getCanonicalDuration());
            }
            case 22: {
                DayTimeDurationValue dtdv = new DayTimeDurationValue(this.getCanonicalDuration());
                return new StringValue(dtdv.getStringValue());
            }
            case 53: {
                return new DurationValue(TimeUtils.getInstance().newDuration(this.duration.getSign() >= 0, null, null, (BigInteger)this.duration.getField(DatatypeConstants.DAYS), (BigInteger)this.duration.getField(DatatypeConstants.HOURS), (BigInteger)this.duration.getField(DatatypeConstants.MINUTES), (BigDecimal)this.duration.getField(DatatypeConstants.SECONDS)));
            }
            case 54: {
                return new YearMonthDurationValue(YearMonthDurationValue.CANONICAL_ZERO_DURATION);
            }
            case 21: {
                DayTimeDurationValue dtdv = new DayTimeDurationValue(this.getCanonicalDuration());
                return new UntypedAtomicValue(dtdv.getStringValue());
            }
        }
        throw new XPathException("XPTY0004: cannot cast '" + Type.getTypeName(this.getItemType()) + "(\"" + this.getStringValue() + "\")' to " + Type.getTypeName(requiredType));
    }

    protected DurationValue createSameKind(Duration dur) throws XPathException {
        return new DayTimeDurationValue(dur);
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        BigDecimal factor;
        if (other instanceof NumericValue) {
            if (((NumericValue)other).isNaN()) {
                throw new XPathException("FOCA0005: Operand is not a number");
            }
            if (((NumericValue)other).isInfinite()) {
                throw new XPathException("FODT0002: Multiplication by infinity overflow");
            }
        }
        boolean isFactorNegative = (factor = this.numberToBigDecimal(other, "Operand to mult should be of numeric type; got: ")).signum() < 0;
        DayTimeDurationValue product = new DayTimeDurationValue(this.duration.multiply(factor.abs()));
        if (isFactorNegative) {
            return new DayTimeDurationValue(product.negate().getCanonicalDuration());
        }
        return new DayTimeDurationValue(product.getCanonicalDuration());
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        BigDecimal divisor;
        if (other.getType() == 55) {
            DecimalValue a = new DecimalValue(this.secondsValueSigned());
            DecimalValue b = new DecimalValue(((DayTimeDurationValue)other).secondsValueSigned());
            return new DecimalValue(a.value.divide(b.value, 20, 4));
        }
        if (other instanceof NumericValue) {
            if (((NumericValue)other).isNaN()) {
                throw new XPathException("FOCA0005: Operand is not a number");
            }
            if (((NumericValue)other).isInfinite()) {
                return new DayTimeDurationValue("PT0S");
            }
            if (((NumericValue)other).isZero()) {
                throw new XPathException("FODT0002: Division by zero");
            }
        }
        boolean isDivisorNegative = (divisor = this.numberToBigDecimal(other, "Operand to div should be of xdt:dayTimeDuration or numeric type; got: ")).signum() < 0;
        BigDecimal secondsValueSigned = this.secondsValueSigned();
        DayTimeDurationValue quotient = this.fromDecimalSeconds(secondsValueSigned.divide(divisor.abs(), Math.max(Math.max(3, secondsValueSigned.scale()), divisor.scale()), 4));
        if (isDivisorNegative) {
            return new DayTimeDurationValue(quotient.negate().getCanonicalDuration());
        }
        return new DayTimeDurationValue(quotient.getCanonicalDuration());
    }

    private DayTimeDurationValue fromDecimalSeconds(BigDecimal x) throws XPathException {
        return new DayTimeDurationValue(TimeUtils.getInstance().newDuration(x.signum() >= 0, null, null, null, null, null, x.abs()));
    }

    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("FORG0006: value of type " + Type.getTypeName(this.getType()) + " has no boolean value.");
    }
}

