/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Collator;
import java.util.BitSet;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.Constants;
import org.exist.xquery.XPathException;
import org.exist.xquery.functions.FunEscapeURI;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class AnyURIValue
extends AtomicValue {
    static BitSet needEncoding = new BitSet(128);
    static final int caseDiff = 32;
    public static final AnyURIValue EMPTY_URI;
    private String uri;

    AnyURIValue() {
        this.uri = "";
    }

    public AnyURIValue(URI uri) {
        this.uri = uri.toString();
    }

    public AnyURIValue(XmldbURI uri) {
        this.uri = uri.toString();
    }

    public AnyURIValue(String s) throws XPathException {
        String escapedString = AnyURIValue.escape(StringValue.trimWhitespace(s));
        try {
            new URI(escapedString);
        }
        catch (URISyntaxException e) {
            try {
                XmldbURI.xmldbUriFor(escapedString);
            }
            catch (URISyntaxException ex) {
                throw new XPathException("Type error: the given string '" + s + "' cannot be cast to " + Type.getTypeName(this.getType()));
            }
        }
        s = StringValue.normalizeWhitespace(s);
        this.uri = StringValue.collapseWhitespace(s);
    }

    public static String escape(String uri) {
        return FunEscapeURI.escape(uri, false);
    }

    public int getType() {
        return 25;
    }

    public String getStringValue() throws XPathException {
        return this.uri;
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return this.uri.length() > 0;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 25: {
                return this;
            }
            case 22: {
                return new StringValue(this.uri);
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:anyURI to " + Type.getTypeName(requiredType));
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.getType() == 25) {
            String otherURI = other.getStringValue();
            int cmp = this.uri.compareTo(otherURI);
            switch (operator) {
                case 4: {
                    return cmp == 0;
                }
                case 5: {
                    return cmp != 0;
                }
                case 1: {
                    return cmp > 0;
                }
                case 2: {
                    return cmp >= 0;
                }
                case 0: {
                    return cmp < 0;
                }
                case 3: {
                    return cmp <= 0;
                }
            }
            throw new XPathException("XPTY0004: cannot apply operator " + Constants.OPS[operator] + " to xs:anyURI");
        }
        return this.compareTo(collator, operator, other.convertTo(25));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 25) {
            String otherURI = other.getStringValue();
            return this.uri.compareTo(otherURI);
        }
        return this.compareTo(collator, other.convertTo(25));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("max is not supported for values of type xs:anyURI");
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("min is not supported for values of type xs:anyURI");
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(AnyURIValue.class)) {
            return 0;
        }
        if (javaClass == XmldbURI.class) {
            return 1;
        }
        if (javaClass == URI.class) {
            return 2;
        }
        if (javaClass == URL.class) {
            return 3;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 4;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(AnyURIValue.class)) {
            return this;
        }
        if (target == XmldbURI.class) {
            return this.toXmldbURI();
        }
        if (target == URI.class) {
            return this.toURI();
        }
        if (target == URL.class) {
            try {
                return new URL(this.uri);
            }
            catch (MalformedURLException e) {
                throw new XPathException("failed to convert " + this.uri + " into a Java URL: " + e.getMessage(), e);
            }
        }
        if (target == String.class || target == CharSequence.class) {
            return this.uri;
        }
        if (target == Object.class) {
            return this.uri;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public XmldbURI toXmldbURI() throws XPathException {
        try {
            return XmldbURI.xmldbUriFor(this.uri, false);
        }
        catch (URISyntaxException e) {
            throw new XPathException("failed to convert " + this.uri + " into an XmldbURI: " + e.getMessage(), e);
        }
    }

    public URI toURI() throws XPathException {
        try {
            return new URI(AnyURIValue.escape(this.uri));
        }
        catch (URISyntaxException e) {
            throw new XPathException("failed to convert " + this.uri + " into an URI: " + e.getMessage(), e);
        }
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            needEncoding.set(i);
        }
        needEncoding.set(127);
        needEncoding.set(32);
        needEncoding.set(60);
        needEncoding.set(62);
        needEncoding.set(34);
        needEncoding.set(123);
        needEncoding.set(125);
        needEncoding.set(124);
        needEncoding.set(92);
        needEncoding.set(94);
        needEncoding.set(96);
        EMPTY_URI = new AnyURIValue();
    }
}

