/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunUnEscapeURI
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("unescape-uri", "http://exist-db.org/xquery/util", "util"), "Returns an un-escaped URL escaped string identified by $a with the encoding scheme indicated by the string $b (e.g. \"UTF-8\"). Decodes encoded sensitive characters from a URL, for example \"%2F\" becomes \"/\", i.e. does the oposite to escape-uri()", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 2));
    public static final FunctionSignature deprecated = new FunctionSignature(new QName("unescape-uri", "http://exist-db.org/xquery/request", "request"), "Returns an un-escaped URL escaped string identified by $a with the encoding scheme indicated by the string $b (e.g. \"UTF-8\"). Decodes encoded sensitive characters from a URL, for example \"%2F\" becomes \"/\", i.e. does the oposite to escape-uri()", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 2), "Moved to the util module. See util:unescape-uri.");

    public FunUnEscapeURI(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            return new StringValue(URLDecoder.decode(args[0].getStringValue(), args[1].getStringValue()));
        }
        catch (UnsupportedEncodingException e) {
            throw new XPathException("Unsupported Encoding Scheme: " + e.getMessage(), e);
        }
    }
}

