/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.exist.management.Agent;
import org.exist.management.AgentFactory;
import org.exist.storage.BrokerPool;
import org.exist.storage.CacheManager;
import org.exist.storage.cache.Cache;
import org.exist.util.DatabaseConfigurationException;

public class DefaultCacheManager
implements CacheManager {
    private static final Logger LOG = Logger.getLogger((Class)DefaultCacheManager.class);
    public static final double MAX_MEM_USE = 0.9;
    public static final double MIN_SHRINK_FACTOR = 0.5;
    public static final double SHRINK_FACTOR = 0.7;
    public static final int SHRINK_THRESHOLD = 10000;
    public static int DEFAULT_CACHE_SIZE = 64;
    public static final String CACHE_SIZE_ATTRIBUTE = "cacheSize";
    public static final String PROPERTY_CACHE_SIZE = "db-connection.cache-size";
    private List caches = new ArrayList();
    private long totalMem;
    private int totalPageCount;
    private int currentPageCount = 0;
    private int maxCacheSize;
    private int pageSize;
    private Cache lastRequest = null;
    private String instanceName;

    public DefaultCacheManager(BrokerPool pool) {
        int buffers;
        int cacheSize;
        this.instanceName = pool.getId();
        this.pageSize = pool.getConfiguration().getInteger("db-connection.page-size");
        if (this.pageSize < 0) {
            this.pageSize = 4096;
        }
        if ((cacheSize = pool.getConfiguration().getInteger(PROPERTY_CACHE_SIZE)) < 0) {
            cacheSize = DEFAULT_CACHE_SIZE;
        }
        this.totalMem = cacheSize * 1024 * 1024;
        this.totalPageCount = buffers = (int)(this.totalMem / (long)this.pageSize);
        this.maxCacheSize = (int)((double)this.totalPageCount * 0.9);
        NumberFormat nf = NumberFormat.getNumberInstance();
        LOG.info((Object)("Cache settings: totalPages: " + nf.format(this.totalPageCount) + "; maxCacheSize: " + nf.format(this.maxCacheSize)));
        this.registerMBean();
    }

    public void registerCache(Cache cache) {
        this.currentPageCount += cache.getBuffers();
        this.caches.add(cache);
        cache.setCacheManager(this);
        this.registerMBean(cache);
    }

    public void deregisterCache(Cache cache) {
        for (int i = 0; i < this.caches.size(); ++i) {
            Cache next = (Cache)this.caches.get(i);
            if (cache != next) continue;
            this.caches.remove(i);
            break;
        }
        this.currentPageCount -= cache.getBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestMem(Cache cache) {
        if (this.currentPageCount >= this.totalPageCount) {
            if (cache.getBuffers() < this.maxCacheSize) {
                this.lastRequest = cache;
            }
            return -1;
        }
        if (cache.getGrowthFactor() > 1.0 && cache.getBuffers() < this.maxCacheSize) {
            DefaultCacheManager defaultCacheManager = this;
            synchronized (defaultCacheManager) {
                if (this.currentPageCount >= this.totalPageCount) {
                    return -1;
                }
                int newCacheSize = (int)((double)cache.getBuffers() * cache.getGrowthFactor());
                if (newCacheSize > this.maxCacheSize) {
                    newCacheSize = this.maxCacheSize;
                }
                if (this.currentPageCount + newCacheSize > this.totalPageCount) {
                    newCacheSize = cache.getBuffers() + (this.totalPageCount - this.currentPageCount);
                }
                if (LOG.isDebugEnabled()) {
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    LOG.debug((Object)("Growing cache " + cache.getFileName() + " (a " + cache.getClass().getName() + ") from " + nf.format(cache.getBuffers()) + " to " + nf.format(newCacheSize)));
                }
                this.currentPageCount -= cache.getBuffers();
                cache.resize(newCacheSize);
                this.currentPageCount += newCacheSize;
                return newCacheSize;
            }
        }
        return -1;
    }

    public void checkCaches() {
        int minSize = (int)((double)this.totalPageCount * 0.5);
        for (int i = 0; i < this.caches.size(); ++i) {
            Cache cache = (Cache)this.caches.get(i);
            if (!(cache.getGrowthFactor() > 1.0)) continue;
            int load = cache.getLoad();
            if (cache.getBuffers() <= minSize || load >= 10000) continue;
            if (LOG.isDebugEnabled()) {
                NumberFormat nf = NumberFormat.getNumberInstance();
                LOG.debug((Object)("Shrinking cache: " + cache.getFileName() + " (a " + cache.getClass().getName() + ") to " + nf.format(cache.getBuffers())));
            }
            this.currentPageCount -= cache.getBuffers();
            cache.resize(this.getDefaultInitialSize());
            this.currentPageCount += this.getDefaultInitialSize();
        }
    }

    public void checkDistribution() {
        if (this.lastRequest == null) {
            return;
        }
        int minSize = (int)((double)this.totalPageCount * 0.5);
        for (int i = 0; i < this.caches.size(); ++i) {
            Cache cache = (Cache)this.caches.get(i);
            if (cache.getBuffers() < minSize) continue;
            int newSize = (int)((double)cache.getBuffers() * 0.7);
            if (LOG.isDebugEnabled()) {
                NumberFormat nf = NumberFormat.getNumberInstance();
                LOG.debug((Object)("Shrinking cache: " + cache.getFileName() + " (a " + cache.getClass().getName() + ") to " + nf.format(newSize)));
            }
            this.currentPageCount -= cache.getBuffers();
            cache.resize(newSize);
            this.currentPageCount += newSize;
            break;
        }
        this.lastRequest = null;
    }

    public long getMaxTotal() {
        return this.totalPageCount;
    }

    public long getCurrentSize() {
        return this.currentPageCount;
    }

    public long getSizeInBytes() {
        return this.currentPageCount * this.pageSize;
    }

    public long getMaxSingle() {
        return this.maxCacheSize;
    }

    public long getTotalMem() {
        return this.totalMem;
    }

    public int getDefaultInitialSize() {
        return DEFAULT_CACHE_SIZE;
    }

    private void registerMBean() {
        Agent agent = AgentFactory.getInstance();
        try {
            agent.addMBean(this.instanceName, "org.exist.management." + this.instanceName + ":type=CacheManager", new org.exist.management.CacheManager(this));
        }
        catch (DatabaseConfigurationException e) {
            LOG.warn((Object)"Exception while registering cache mbean.", (Throwable)e);
        }
    }

    private void registerMBean(Cache cache) {
        Agent agent = AgentFactory.getInstance();
        try {
            agent.addMBean(this.instanceName, "org.exist.management." + this.instanceName + ":type=CacheManager.Cache,name=" + cache.getFileName() + ",cache-type=" + cache.getType(), new org.exist.management.Cache(cache));
        }
        catch (DatabaseConfigurationException e) {
            LOG.warn((Object)"Exception while registering cache mbean.", (Throwable)e);
        }
    }
}

