/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fulltext;

import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.XMLString;

public class ElementContent {
    private static final Logger LOG = Logger.getLogger((Class)ElementContent.class);
    private QName nodeName;
    private boolean mixedContent;
    private TextSpan first = null;
    private TextSpan last = null;

    public ElementContent(QName nodeName, boolean mixedContent) {
        this.nodeName = nodeName;
        this.mixedContent = mixedContent;
    }

    public void append(XMLString string) {
        if (this.mixedContent) {
            this.appendString(string);
        } else {
            this.appendSpan(string);
        }
    }

    public void appendSpan(XMLString string) {
        if (this.first == null) {
            this.last = this.first = new TextSpan(string);
        } else {
            TextSpan span;
            this.last.next = span = new TextSpan(string);
            this.last = span;
        }
    }

    public void appendString(XMLString string) {
        if (this.first == null) {
            this.last = this.first = new TextSpan(string);
        } else {
            this.last.content.append(string);
        }
    }

    public QName getNodeName() {
        return this.nodeName;
    }

    public void setMixedContent(boolean mixedContent) {
        this.mixedContent = mixedContent;
    }

    public TextSpan getFirst() {
        return this.first;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (TextSpan span = this.getFirst(); span != null; span = span.getNext()) {
            buf.append(span.getContent()).append('|');
        }
        return buf.toString();
    }

    public static class TextSpan {
        XMLString content;
        TextSpan next = null;

        TextSpan(XMLString content) {
            this.content = new XMLString(content);
        }

        public XMLString getContent() {
            return this.content;
        }

        public TextSpan getNext() {
            return this.next;
        }
    }
}

