/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.TargetMatch;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeDesignator;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.FunctionTypeException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.exist.client.xacml.Abbreviator;
import org.exist.security.xacml.XACMLConstants;
import org.exist.security.xacml.XACMLUtil;

public class TargetTableModel
implements TableModel {
    private static final Logger LOG = Logger.getLogger((Class)TargetTableModel.class);
    private static final String UNSPECIFIED = "[match all]";
    private static final AttributeDesignator[] SUBJECT_ATTRIBUTES = new AttributeDesignator[4];
    private static final AttributeDesignator[] ACTION_ATTRIBUTES;
    private static final AttributeDesignator[] RESOURCE_ATTRIBUTES;
    private static final AttributeDesignator[] ENVIRONMENT_ATTRIBUTES;
    private int type;
    private List listeners;
    private AttributeDesignator[] attributes;
    private Abbreviator abbrev;
    private AttributeValue[][] values;
    private URI[][] functions;

    private TargetTableModel() {
    }

    public TargetTableModel(int type, Abbreviator abbrev) {
        this.abbrev = abbrev;
        this.type = type;
        this.attributes = TargetTableModel.getAttributes(type);
        this.values = new AttributeValue[0][0];
        this.functions = new URI[0][0];
    }

    private static AttributeDesignator[] getAttributes(int type) {
        switch (type) {
            case 2: {
                return ACTION_ATTRIBUTES;
            }
            case 1: {
                return RESOURCE_ATTRIBUTES;
            }
            case 0: {
                return SUBJECT_ATTRIBUTES;
            }
            case 3: {
                return ENVIRONMENT_ATTRIBUTES;
            }
        }
        throw new IllegalArgumentException("Invalid target type");
    }

    public int getColumnCount() {
        return this.attributes.length;
    }

    public int getRowCount() {
        return this.values.length + 1;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    public Object getValueAt(int row, int col) {
        if (row == this.values.length) {
            return "";
        }
        AttributeValue value = this.values[row][col];
        if (value == null) {
            return UNSPECIFIED;
        }
        URI functionId = this.functions[row][col];
        if (functionId == null) {
            return UNSPECIFIED;
        }
        String functionString = this.abbrev.getAbbreviatedTargetFunctionId(functionId, this.attributes[col].getType());
        if (functionString == null) {
            LOG.warn((Object)("Abbreviated function string was unexpectedly null.  FunctionId URI was '" + functionId + "' (Row " + row + ", column " + col + ")"));
            return UNSPECIFIED;
        }
        String stringValue = value.encode();
        if (stringValue == null) {
            LOG.warn((Object)("String representation of a non-null attribute value was unexpectedly null.  (Row " + row + ", column " + col + ")"));
            return UNSPECIFIED;
        }
        return "<html>" + XACMLUtil.XMLEscape(functionString) + "&nbsp;<b>" + XACMLUtil.XMLEscape(stringValue) + "</b>";
    }

    public void setValueAt(Object value, int row, int col) {
    }

    public AttributeDesignator getAttribute(int col) {
        return this.attributes[col];
    }

    public URI getFunctionId(int row, int col) {
        return row == this.values.length ? null : this.functions[row][col];
    }

    public AttributeValue getValue(int row, int col) {
        return row == this.values.length ? null : this.values[row][col];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(URI functionId, AttributeValue value, int row, int col) {
        TableModelEvent event;
        if (row == this.values.length) {
            if (value == null) return;
            this.addRow();
            event = new TableModelEvent(this, row, row, -1, 1);
        } else {
            event = new TableModelEvent(this, row, row, col, 0);
        }
        this.values[row][col] = value;
        this.functions[row][col] = functionId;
        if (value == null && row < this.values.length) {
            boolean empty = true;
            for (int i = 0; i < this.attributes.length && empty; ++i) {
                if (this.values[row][i] == null) continue;
                empty = false;
            }
            if (empty) {
                this.removeRow(row);
                return;
            }
        }
        this.fireTableChanged(event);
    }

    private void addRow() {
        URI[][] newF = new URI[this.functions.length + 1][];
        System.arraycopy(this.functions, 0, newF, 0, this.functions.length);
        newF[this.functions.length] = new URI[this.attributes.length];
        this.functions = newF;
        AttributeValue[][] newV = new AttributeValue[this.values.length + 1][];
        System.arraycopy(this.values, 0, newV, 0, this.values.length);
        newV[this.values.length] = new AttributeValue[this.attributes.length];
        this.values = newV;
    }

    public void removeRow(int row) {
        if (this.functions.length == 0 || this.functions.length >= row || row < 0) {
            return;
        }
        int row1 = row + 1;
        URI[][] newF = new URI[this.functions.length - 1][];
        System.arraycopy(this.functions, 0, newF, 0, row);
        System.arraycopy(this.functions, row1, newF, row1, this.functions.length - row1);
        this.functions = newF;
        AttributeValue[][] newV = new AttributeValue[this.values.length - 1][];
        System.arraycopy(this.values, 0, newV, 0, row);
        System.arraycopy(this.values, row1, newV, row1, this.values.length - row1);
        this.values = newV;
        TableModelEvent event = new TableModelEvent(this, row, row, -1, -1);
        this.fireTableChanged(event);
    }

    public void setTarget(List target) {
        int length = target == null ? 0 : target.size();
        this.functions = new URI[length][this.attributes.length];
        this.values = new AttributeValue[length][this.attributes.length];
        for (int i = 0; i < length; ++i) {
            List matches = (List)target.get(i);
            int col = -1;
            Iterator it = matches.iterator();
            while (it.hasNext() && col < 0) {
                TargetMatch match = (TargetMatch)it.next();
                Evaluatable attribute = match.getMatchEvaluatable();
                if (!(attribute instanceof AttributeDesignator) || (col = this.getIndex((AttributeDesignator)attribute)) < 0) continue;
                this.setValue(i, col, match);
            }
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    private void fireTableChanged(TableModelEvent event) {
        if (this.listeners == null) {
            return;
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((TableModelListener)it.next()).tableChanged(event);
        }
    }

    public List createTarget() {
        ArrayList list = new ArrayList(this.values.length);
        for (int row = 0; row < this.values.length; ++row) {
            ArrayList<TargetMatch> matches = new ArrayList<TargetMatch>(this.attributes.length);
            for (int col = 0; col < this.attributes.length; ++col) {
                AttributeValue value = this.values[row][col];
                URI functionId = this.functions[row][col];
                if (value == null || functionId == null) continue;
                try {
                    Function f = FunctionFactory.getTargetInstance().createFunction(functionId);
                    if (f == null) continue;
                    matches.add(new TargetMatch(this.type, f, (Evaluatable)this.attributes[col], value));
                    continue;
                }
                catch (UnknownIdentifierException e) {
                    LOG.warn((Object)e);
                    continue;
                }
                catch (FunctionTypeException e) {
                    LOG.warn((Object)e);
                }
            }
            if (matches.size() <= 0) continue;
            list.add(matches);
        }
        return list.size() > 0 ? list : null;
    }

    public void setValue(int row, int col, TargetMatch match) {
        AttributeValue value = match.getMatchValue();
        URI functionId = match.getMatchFunction().getIdentifier();
        this.setValue(functionId, value, row, col);
    }

    public int getIndex(AttributeDesignator attribute) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!TargetTableModel.equals(attribute, this.attributes[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean equals(AttributeDesignator one, AttributeDesignator two) {
        if (one == null) {
            return two == null;
        }
        if (two == null) {
            return false;
        }
        if (!one.getId().equals(two.getId())) {
            return false;
        }
        if (!one.getType().equals(two.getType())) {
            return false;
        }
        if (!TargetTableModel.equals(one.getCategory(), two.getCategory())) {
            return false;
        }
        return TargetTableModel.equals(one.getIssuer(), two.getIssuer());
    }

    public static boolean equals(URI one, URI two) {
        if (one == null) {
            return two == null;
        }
        if (two == null) {
            return false;
        }
        return one.equals(two);
    }

    public String getColumnName(int pos) {
        URI attributeID = this.attributes[pos].getId();
        return this.abbrev.getAbbreviatedId(attributeID);
    }

    public void addTableModelListener(TableModelListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        if (this.listeners == null || listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    static {
        TargetTableModel.SUBJECT_ATTRIBUTES[0] = new AttributeDesignator(0, XACMLConstants.STRING_TYPE, XACMLConstants.SUBJECT_ID_ATTRIBUTE, false);
        TargetTableModel.SUBJECT_ATTRIBUTES[1] = new AttributeDesignator(0, XACMLConstants.URI_TYPE, XACMLConstants.SUBJECT_NS_ATTRIBUTE, false);
        TargetTableModel.SUBJECT_ATTRIBUTES[2] = new AttributeDesignator(0, XACMLConstants.STRING_TYPE, XACMLConstants.GROUP_ATTRIBUTE, false);
        TargetTableModel.SUBJECT_ATTRIBUTES[3] = new AttributeDesignator(0, XACMLConstants.STRING_TYPE, XACMLConstants.USER_NAME_ATTRIBUTE, false);
        ACTION_ATTRIBUTES = new AttributeDesignator[2];
        TargetTableModel.ACTION_ATTRIBUTES[0] = new AttributeDesignator(2, XACMLConstants.STRING_TYPE, XACMLConstants.ACTION_ID_ATTRIBUTE, false);
        TargetTableModel.ACTION_ATTRIBUTES[1] = new AttributeDesignator(2, XACMLConstants.URI_TYPE, XACMLConstants.ACTION_NS_ATTRIBUTE, false);
        RESOURCE_ATTRIBUTES = new AttributeDesignator[6];
        TargetTableModel.RESOURCE_ATTRIBUTES[0] = new AttributeDesignator(1, XACMLConstants.STRING_TYPE, XACMLConstants.RESOURCE_ID_ATTRIBUTE, false);
        TargetTableModel.RESOURCE_ATTRIBUTES[1] = new AttributeDesignator(1, XACMLConstants.URI_TYPE, XACMLConstants.MODULE_NS_ATTRIBUTE, false);
        TargetTableModel.RESOURCE_ATTRIBUTES[2] = new AttributeDesignator(1, XACMLConstants.STRING_TYPE, XACMLConstants.RESOURCE_CATEGORY_ATTRIBUTE, false);
        TargetTableModel.RESOURCE_ATTRIBUTES[3] = new AttributeDesignator(1, XACMLConstants.STRING_TYPE, XACMLConstants.MODULE_CATEGORY_ATTRIBUTE, false);
        TargetTableModel.RESOURCE_ATTRIBUTES[4] = new AttributeDesignator(1, XACMLConstants.STRING_TYPE, XACMLConstants.SOURCE_KEY_ATTRIBUTE, false);
        TargetTableModel.RESOURCE_ATTRIBUTES[5] = new AttributeDesignator(1, XACMLConstants.STRING_TYPE, XACMLConstants.SOURCE_TYPE_ATTRIBUTE, false);
        ENVIRONMENT_ATTRIBUTES = new AttributeDesignator[4];
        TargetTableModel.ENVIRONMENT_ATTRIBUTES[0] = new AttributeDesignator(3, XACMLConstants.DATE_TYPE, XACMLConstants.CURRENT_DATE_ATTRIBUTE, false);
        TargetTableModel.ENVIRONMENT_ATTRIBUTES[1] = new AttributeDesignator(3, XACMLConstants.TIME_TYPE, XACMLConstants.CURRENT_TIME_ATTRIBUTE, false);
        TargetTableModel.ENVIRONMENT_ATTRIBUTES[2] = new AttributeDesignator(3, XACMLConstants.DATETIME_TYPE, XACMLConstants.CURRENT_DATETIME_ATTRIBUTE, false);
        TargetTableModel.ENVIRONMENT_ATTRIBUTES[3] = new AttributeDesignator(3, XACMLConstants.STRING_TYPE, XACMLConstants.ACCESS_CONTEXT_ATTRIBUTE, false);
    }
}

