/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.Timer;

public class AutoScroller
implements ActionListener {
    private static final int DELTA = 8;
    private static final int DEFAULT_INCREMENT = 42;
    private static final int DEFAULT_INITIAL_DELAY = 400;
    private static final int DEFAULT_REPEAT_DELAY = 50;
    private Component comp;
    private Point cursorLocation;
    private Timer scrollTimer = new Timer(50, this);

    public AutoScroller() {
        this.scrollTimer.setCoalesce(true);
        this.scrollTimer.setRepeats(true);
        this.scrollTimer.setInitialDelay(400);
        this.scrollTimer.setDelay(50);
    }

    public void stop() {
        this.comp = null;
        this.cursorLocation = null;
        this.scrollTimer.stop();
    }

    public void autoscroll(Component comp, Point cursorLocation) {
        this.comp = comp;
        this.cursorLocation = cursorLocation;
        this.scrollTimer.restart();
    }

    public void actionPerformed(ActionEvent event) {
        Container parent = this.comp.getParent();
        if (!(parent instanceof JViewport)) {
            return;
        }
        JViewport view = (JViewport)parent;
        Rectangle rect = view.getViewRect();
        int horizontal = 0;
        int vertical = 0;
        int verticalDiffTop = this.cursorLocation.y - rect.y;
        int verticalDiffBottom = rect.height - verticalDiffTop;
        int horizontalDiffLeft = this.cursorLocation.x - rect.x;
        int horizontalDiffRight = rect.width - horizontalDiffLeft;
        if (verticalDiffTop < 8) {
            vertical = -1;
        } else if (verticalDiffBottom < 8) {
            vertical = 1;
        }
        if (horizontalDiffLeft < 8) {
            horizontal = -1;
        } else if (horizontalDiffRight < 8) {
            horizontal = 1;
        }
        if (this.comp instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)this.comp);
            vertical *= scrollable.getScrollableUnitIncrement(rect, 1, vertical);
            horizontal *= scrollable.getScrollableUnitIncrement(rect, 0, horizontal);
        } else {
            vertical *= 42;
            horizontal *= 42;
        }
        Dimension viewSize = view.getViewSize();
        Point newPosition = new Point(rect.x + horizontal, rect.y + vertical);
        if (newPosition.x < 0) {
            newPosition.x = 0;
        } else if (newPosition.x > viewSize.width - rect.width) {
            newPosition.x = viewSize.width - rect.width;
        }
        if (newPosition.y < 0) {
            newPosition.y = 0;
        } else if (newPosition.y > viewSize.height - rect.height) {
            newPosition.y = viewSize.height - rect.height;
        }
        if (newPosition.x != rect.x || newPosition.y != rect.y) {
            this.cursorLocation.x += newPosition.x - rect.x;
            this.cursorLocation.y += newPosition.y - rect.y;
            view.setViewPosition(newPosition);
        }
    }
}

