/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.EventFactory;
import com.topologi.diffx.event.impl.ProcessingInstructionEvent;
import com.topologi.diffx.load.AttributeComparator;
import com.topologi.diffx.load.LoadingException;
import com.topologi.diffx.load.XMLRecorder;
import com.topologi.diffx.load.text.TextTokeniser;
import com.topologi.diffx.load.text.TokeniserFactory;
import com.topologi.diffx.sequence.EventSequence;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public final class DOMRecorder
implements XMLRecorder {
    private static final boolean DEBUG = false;
    private DiffXConfig config = new DiffXConfig();
    private transient EventFactory efactory = null;
    private transient TokeniserFactory tfactory = null;
    private transient EventSequence sequence = null;
    private transient int currentWeight = -1;
    private transient ArrayList weights = new ArrayList();
    private transient boolean isFragment = true;

    public DiffXConfig getConfig() {
        return this.config;
    }

    public void setConfig(DiffXConfig diffXConfig) {
        this.config = diffXConfig;
    }

    public EventSequence process(File file) throws LoadingException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        return this.process(new InputSource(bufferedInputStream));
    }

    public EventSequence process(String string) throws LoadingException {
        return this.process(new InputSource(new StringReader(string)));
    }

    public EventSequence process(InputSource inputSource) throws LoadingException {
        this.isFragment = false;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(this.config.isNamespaceAware());
        documentBuilderFactory.setExpandEntityReferences(true);
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return this.process(document);
        }
        catch (Exception exception) {
            throw new LoadingException(exception);
        }
    }

    public EventSequence process(Node node) throws LoadingException {
        this.efactory = new EventFactory(this.config.isNamespaceAware());
        this.tfactory = new TokeniserFactory(this.config);
        this.sequence = new EventSequence();
        this.loadNode(node);
        this.isFragment = true;
        return this.sequence;
    }

    private void loadNode(Node node) throws LoadingException {
        if (node instanceof Element) {
            this.load((Element)node);
        }
        if (node instanceof Text) {
            this.load((Text)node);
        } else if (node instanceof Attr) {
            this.load((Attr)node);
        } else if (node instanceof Document) {
            this.load((Document)node);
        } else if (node instanceof ProcessingInstruction) {
            this.load((ProcessingInstruction)node);
        }
    }

    private void load(Document document) throws LoadingException {
        this.load(document.getDocumentElement());
    }

    private void load(Element element) throws LoadingException {
        Object[] objectArray;
        Object object;
        if (this.currentWeight > 0) {
            this.weights.add(new Integer(this.currentWeight));
        }
        this.currentWeight = 1;
        OpenElementEvent openElementEvent = null;
        if (this.config.isNamespaceAware()) {
            String string;
            object = element.getNamespaceURI() == null ? "" : element.getNamespaceURI();
            objectArray = element.getLocalName();
            if (this.isFragment && (string = element.getPrefix()) != null && this.isFragment) {
                this.sequence.mapPrefix((String)object, string);
            }
            openElementEvent = this.efactory.makeOpenElement((String)object, (String)objectArray);
        } else {
            openElementEvent = this.efactory.makeOpenElement(null, element.getNodeName());
        }
        this.sequence.addEvent(openElementEvent);
        object = element.getAttributes();
        if (object.getLength() == 1) {
            this.load((Attr)object.item(0));
        } else if (object.getLength() > 1) {
            int n;
            objectArray = new String[object.getLength()];
            for (n = 0; n < object.getLength(); ++n) {
                Attr attr = (Attr)object.item(n);
                objectArray[n] = attr.getName();
            }
            Arrays.sort(objectArray);
            for (n = 0; n < objectArray.length; ++n) {
                this.load((Attr)object.getNamedItem((String)objectArray[n]));
            }
        }
        objectArray = element.getChildNodes();
        for (int i = 0; i < objectArray.getLength(); ++i) {
            this.loadNode(objectArray.item(i));
        }
        CloseElementEvent closeElementEvent = this.efactory.makeCloseElement(openElementEvent);
        this.sequence.addEvent(closeElementEvent);
        closeElementEvent.setWeight(this.currentWeight);
        openElementEvent.setWeight(this.currentWeight);
        this.currentWeight += this.popWeight();
    }

    private void load(Text text) throws LoadingException {
        TextTokeniser textTokeniser = this.tfactory.makeTokeniser(text.getData());
        for (int i = 0; i < textTokeniser.countTokens(); ++i) {
            this.sequence.addEvent(textTokeniser.nextToken());
            ++this.currentWeight;
        }
    }

    private void load(ProcessingInstruction processingInstruction) throws LoadingException {
        this.sequence.addEvent(new ProcessingInstructionEvent(processingInstruction.getTarget(), processingInstruction.getData()));
        ++this.currentWeight;
    }

    private int popWeight() {
        if (this.weights.size() > 0) {
            return (Integer)this.weights.remove(this.weights.size() - 1);
        }
        return 0;
    }

    private void handleAttributes(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap.getLength() == 1) {
            this.load((Attr)namedNodeMap.item(0));
        } else if (namedNodeMap.getLength() > 1) {
            int n;
            AttributeEvent[] attributeEventArray = new AttributeEvent[namedNodeMap.getLength()];
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                Attr attr = (Attr)namedNodeMap.item(n);
                attributeEventArray[n] = this.efactory.makeAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeName(), attr.getValue());
            }
            Arrays.sort(attributeEventArray, new AttributeComparator());
            for (n = 0; n < attributeEventArray.length; ++n) {
                this.load(attributeEventArray[n]);
            }
        }
    }

    private void load(Attr attr) {
        this.load(this.efactory.makeAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeName(), attr.getValue()));
    }

    private void load(AttributeEvent attributeEvent) {
        if ("http://www.w3.org/2000/xmlns/".equals(attributeEvent.getURI())) {
            this.sequence.mapPrefix(attributeEvent.getValue(), attributeEvent.getName());
        } else {
            attributeEvent.setWeight(2);
            this.currentWeight += 2;
            this.sequence.addEvent(attributeEvent);
        }
    }
}

