/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.format;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.CharEvent;
import com.topologi.diffx.event.impl.CharactersEventBase;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.format.XMLDiffXFormatter;
import com.topologi.diffx.sequence.PrefixMapping;
import com.topologi.diffx.xml.NSAwareXMLWriter;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;

public final class SmartXMLFormatter
implements XMLDiffXFormatter {
    private static final boolean DEBUG = false;
    private final XMLWriter xml;
    private DiffXConfig config = new DiffXConfig();
    private transient boolean writeXMLDeclaration = true;

    public SmartXMLFormatter() throws IOException {
        this(new PrintWriter(System.out));
    }

    public SmartXMLFormatter(Writer writer) throws IOException {
        this.xml = new NSAwareXMLWriter(writer, false);
        this.xml.xmlDecl();
        this.xml.setPrefixMapping("http://www.topologi.org/2004/Diff-X", "dfx");
        this.xml.setPrefixMapping("http://www.topologi.org/2004/Diff-X/Delete", "del");
    }

    public void format(DiffXEvent diffXEvent) throws IOException {
        diffXEvent.toXML(this.xml);
        if (diffXEvent instanceof CharactersEventBase && this.config.isIgnoreWhiteSpace() && !this.config.isPreserveWhiteSpace()) {
            this.xml.writeXML(" ");
        }
        this.xml.flush();
    }

    public void insert(DiffXEvent diffXEvent) throws IOException {
        if (diffXEvent instanceof OpenElementEvent) {
            diffXEvent.toXML(this.xml);
            this.xml.attribute("dfx:insert", "true");
        } else if (diffXEvent == SpaceEvent.NEW_LINE) {
            diffXEvent.toXML(this.xml);
        } else if (diffXEvent instanceof CharactersEventBase) {
            this.xml.openElement("ins", false);
            diffXEvent.toXML(this.xml);
            this.xml.closeElement();
            if (this.config.isIgnoreWhiteSpace() && !this.config.isPreserveWhiteSpace()) {
                this.xml.writeXML(" ");
            }
        } else if (diffXEvent instanceof AttributeEvent) {
            diffXEvent.toXML(this.xml);
        } else if (diffXEvent instanceof CharEvent) {
            this.xml.openElement("ins", false);
            diffXEvent.toXML(this.xml);
            this.xml.closeElement();
        } else {
            diffXEvent.toXML(this.xml);
        }
        this.xml.flush();
    }

    public void delete(DiffXEvent diffXEvent) throws IOException {
        if (diffXEvent instanceof OpenElementEvent) {
            diffXEvent.toXML(this.xml);
            this.xml.attribute("dfx:delete", "true");
        } else if (diffXEvent == SpaceEvent.NEW_LINE) {
            diffXEvent.toXML(this.xml);
        } else if (diffXEvent instanceof CharactersEventBase) {
            this.xml.openElement("del", false);
            diffXEvent.toXML(this.xml);
            this.xml.closeElement();
            if (this.config.isIgnoreWhiteSpace() && !this.config.isPreserveWhiteSpace()) {
                this.xml.writeXML(" ");
            }
        } else if (diffXEvent instanceof AttributeEvent) {
            this.xml.attribute("del:" + ((AttributeEvent)diffXEvent).getName(), ((AttributeEvent)diffXEvent).getValue());
        } else if (diffXEvent instanceof CharEvent) {
            this.xml.openElement("del", false);
            diffXEvent.toXML(this.xml);
            this.xml.closeElement();
        } else {
            diffXEvent.toXML(this.xml);
        }
        this.xml.flush();
    }

    public void setConfig(DiffXConfig diffXConfig) {
        this.config = diffXConfig;
    }

    public void setWriteXMLDeclaration(boolean bl) {
        this.writeXMLDeclaration = bl;
    }

    public void declarePrefixMapping(PrefixMapping prefixMapping) {
        Enumeration enumeration = prefixMapping.getURIs();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.xml.setPrefixMapping(string, prefixMapping.getPrefix(string));
        }
    }
}

