/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.event.impl;

import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.impl.DiffXEventBase;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;

public final class AttributeEventImpl
extends DiffXEventBase
implements AttributeEvent {
    private final String name;
    private final String value;

    public AttributeEventImpl(String string, String string2) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("Attribute must have a name.");
        }
        if (string2 == null) {
            throw new NullPointerException("The attribute value cannot be null, use \"\".");
        }
        this.name = string;
        this.value = string2;
    }

    public String getName() {
        return this.name;
    }

    public String getURI() {
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode();
    }

    public boolean equals(DiffXEvent diffXEvent) {
        if (diffXEvent.getClass() != this.getClass()) {
            return false;
        }
        AttributeEventImpl attributeEventImpl = (AttributeEventImpl)diffXEvent;
        return attributeEventImpl.name.equals(this.name) && attributeEventImpl.value.equals(this.value);
    }

    public String toString() {
        return "attribute: " + this.name + "=" + this.value;
    }

    public void toXML(XMLWriter xMLWriter) throws IOException {
        xMLWriter.attribute(this.name, this.value);
    }

    public StringBuffer toXML(StringBuffer stringBuffer) throws NullPointerException {
        stringBuffer.append(' ');
        stringBuffer.append(this.name);
        stringBuffer.append("=\"");
        stringBuffer.append(ESC.toAttributeValue(this.value));
        stringBuffer.append('\"');
        return stringBuffer;
    }
}

