/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.util.Prime;
import org.cdlib.xtf.util.DiskHashReader;
import org.cdlib.xtf.util.PackedByteBuf;
import org.cdlib.xtf.util.StructuredFile;
import org.cdlib.xtf.util.SubStoreWriter;
import org.cdlib.xtf.util.Tester;

public class DiskHashWriter {
    private HashMap memMap = new HashMap(100);
    public static final Tester tester = new Tester("DiskHash"){

        protected void testImpl() throws Exception {
            StructuredFile.tester.test();
            File testFile = new File("DiskHashTest.sf");
            StructuredFile f = null;
            try {
                f = StructuredFile.create(testFile);
                DiskHashWriter w = new DiskHashWriter();
                PackedByteBuf buf = new PackedByteBuf(20);
                buf.writeInt(11);
                buf.writeString("hello");
                w.put("foo", buf);
                buf.reset();
                buf.writeInt(22);
                buf.writeString("kangaroo");
                w.put("bar", buf);
                w.outputTo(f.createSubStore("testhash"));
                DiskHashReader r = new DiskHashReader(f.openSubStore("testhash"));
                buf = r.find("bar");
                if (!$assertionsDisabled && buf == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && buf.readInt() != 22) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !buf.readString().equals("kangaroo")) {
                    throw new AssertionError();
                }
                buf = r.find("foo");
                if (!$assertionsDisabled && buf == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && buf.readInt() != 11) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !buf.readString().equals("hello")) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && r.find("xyz") != null) {
                    throw new AssertionError();
                }
            }
            finally {
                if (f != null) {
                    f.close();
                }
                testFile.delete();
            }
        }
    };

    public void put(String key, PackedByteBuf val) {
        if (key.length() == 0) {
            key = " ";
        }
        PackedByteBuf cloned = (PackedByteBuf)val.clone();
        cloned.doNotCompress();
        this.memMap.put(key, cloned);
    }

    public void outputTo(SubStoreWriter out) throws IOException {
        int startOffset;
        int nItems = this.memMap.size();
        int hashSize = Prime.findAfter(nItems * 2);
        PackedByteBuf[] slots = new PackedByteBuf[hashSize];
        int maxSlotSize = 0;
        for (String key : this.memMap.keySet()) {
            PackedByteBuf val = (PackedByteBuf)this.memMap.get(key);
            int slotNum = (key.hashCode() & 0xFFFFFF) % hashSize;
            if (slots[slotNum] == null) {
                slots[slotNum] = new PackedByteBuf(val.length() + key.length() + 5);
            }
            slots[slotNum].writeString(key);
            slots[slotNum].writeBuffer(val);
        }
        int i = 0;
        while (i < hashSize) {
            if (slots[i] != null) {
                slots[i].writeString("");
                maxSlotSize = Math.max(maxSlotSize, slots[i].length());
            }
            ++i;
        }
        out.write("hash".getBytes());
        out.writeInt(hashSize);
        out.writeInt(maxSlotSize);
        assert (12 == (int)out.length());
        int curOffset = startOffset = (int)out.length() + hashSize * 4;
        int i2 = 0;
        while (i2 < hashSize) {
            if (slots[i2] == null) {
                out.writeInt(0);
            } else {
                out.writeInt(curOffset);
                curOffset += slots[i2].length();
                assert (slots[i2].length() <= maxSlotSize);
            }
            ++i2;
        }
        assert (out.length() == (long)startOffset);
        i2 = 0;
        while (i2 < hashSize) {
            if (slots[i2] != null) {
                slots[i2].output(out);
            }
            ++i2;
        }
        assert (out.length() == (long)curOffset);
        out.write(new byte[maxSlotSize]);
        out.close();
    }
}

