/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cdlib.xtf.util.ProcessRunner;
import org.cdlib.xtf.util.SubDirFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirSync {
    public static final int MAX_SELECTIVE_SYNC = 500;
    private static final int MAX_RSYNC_BATCH = 2;
    private SubDirFilter filter;

    public DirSync() {
        this(null);
    }

    public DirSync(SubDirFilter filter) {
        this.filter = filter;
    }

    public void syncDirs(File srcDir, File dstDir) throws IOException {
        if (this.filter == null || this.filter.size() > 500 || this.filter.size() == 1 && new File(this.filter.getTargets().get(0)).getCanonicalFile().equals(srcDir.getCanonicalFile())) {
            this.runRsync(srcDir, dstDir, null, new String[]{"--exclude=scanDirs.list"});
        } else {
            this.selectiveSync(srcDir, dstDir);
        }
        this.runRsync(new File(srcDir, "scanDirs.list"), dstDir, null, null);
    }

    private void selectiveSync(File srcDir, File dstDir) throws IOException {
        this.runRsync(srcDir, dstDir, null, new String[]{"--exclude=/*/", "--exclude=scanDirs.list"});
        if (!this.filter.isEmpty()) {
            ArrayList<String> dirBatch = new ArrayList<String>();
            String basePath = String.valueOf(srcDir.getCanonicalPath()) + "/";
            for (String target : this.filter.getTargets()) {
                String targetPath = new File(target).getCanonicalPath();
                assert (targetPath.startsWith(basePath)) : "targetPath '" + targetPath.toString() + "' should start with basePAth '" + basePath.toString() + "'";
                targetPath = targetPath.substring(basePath.length());
                dirBatch.add(targetPath);
                if (dirBatch.size() < 2) continue;
                this.runRsync(srcDir, dstDir, dirBatch, null);
                dirBatch.clear();
            }
            if (!dirBatch.isEmpty()) {
                this.runRsync(srcDir, dstDir, dirBatch, new String[]{"--exclude=scanDirs.list"});
            }
        }
    }

    public void runRsync(File src, File dst, List<String> subDirs, String[] extraArgs) throws IOException {
        try {
            ArrayList<String> args = new ArrayList<String>(6);
            args.add("rsync");
            args.add("-av");
            args.add("--delete");
            if (extraArgs != null) {
                String[] stringArray = extraArgs;
                int n = extraArgs.length;
                int n2 = 0;
                while (n2 < n) {
                    String extra = stringArray[n2];
                    args.add(extra);
                    ++n2;
                }
            }
            if (src.isDirectory()) {
                args.add("--link-dest=" + src.getAbsolutePath() + "/");
            }
            if (subDirs != null) {
                args.add("--relative");
                for (String subDir : subDirs) {
                    if (!new File(src.getAbsolutePath(), subDir).canRead()) continue;
                    args.add(String.valueOf(src.getAbsolutePath()) + "/./" + subDir);
                }
            } else {
                args.add(String.valueOf(src.getAbsolutePath()) + (src.isDirectory() ? "/" : ""));
            }
            args.add(String.valueOf(dst.getAbsolutePath()) + (dst.isDirectory() ? "/" : ""));
            String[] argArray = args.toArray(new String[args.size()]);
            ProcessRunner.runAndGrab(argArray, "", 0);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ProcessRunner.CommandFailedException e) {
            throw new IOException(e.getMessage());
        }
    }
}

