/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.cdlib.xtf.textIndexer.IndexInfo;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public class IndexerConfig {
    public String xtfHomePath;
    public String cfgFilePath = "conf/textIndexer.conf";
    public int traceLevel = 4;
    public boolean clean = false;
    public boolean mustClean;
    public boolean force = false;
    public boolean buildLazyFiles = true;
    public boolean optimize = true;
    public boolean updateSpellDict = true;
    public boolean skipIndexing = false;
    public boolean validate = true;
    public boolean rotate = true;
    public IndexInfo indexInfo = new IndexInfo();

    public int readCmdLine(String[] args, int startArg) {
        if (startArg >= args.length) {
            return -1;
        }
        boolean gotIdxName = false;
        this.indexInfo.subDirs = null;
        int i = startArg;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-config")) {
                if (++i >= args.length) {
                    return -1;
                }
                this.cfgFilePath = args[i];
            } else if (args[i].equalsIgnoreCase("-index")) {
                if (++i >= args.length) {
                    return -1;
                }
                this.indexInfo.indexName = args[i];
                gotIdxName = true;
            } else if (args[i].equalsIgnoreCase("-dir")) {
                if (++i >= args.length) {
                    return -1;
                }
                if (this.indexInfo.subDirs == null) {
                    this.indexInfo.subDirs = new ArrayList();
                }
                this.indexInfo.subDirs.add(args[i]);
            } else if (args[i].equalsIgnoreCase("-dirList")) {
                if (++i >= args.length) {
                    return -1;
                }
                String fileName = args[i];
                try {
                    String line;
                    String filePath = Path.resolveRelOrAbs(this.xtfHomePath, fileName);
                    FileInputStream inStream = new FileInputStream(filePath);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
                    while ((line = reader.readLine()) != null) {
                        String dirName = line.trim();
                        if (dirName.length() == 0) continue;
                        if (this.indexInfo.subDirs == null) {
                            this.indexInfo.subDirs = new ArrayList();
                        }
                        this.indexInfo.subDirs.add(dirName);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    Trace.error("Error reading directory list: " + e.toString());
                    Trace.error("");
                    return -1;
                }
            } else if (args[i].equalsIgnoreCase("-clean")) {
                this.clean = true;
                this.force = false;
            } else if (args[i].equalsIgnoreCase("-incremental")) {
                this.clean = false;
                this.force = false;
            } else if (args[i].equalsIgnoreCase("-force")) {
                this.clean = false;
                this.force = true;
            } else if (args[i].equalsIgnoreCase("-optimize")) {
                this.optimize = true;
            } else if (args[i].equalsIgnoreCase("-nooptimize")) {
                this.optimize = false;
            } else if (args[i].equalsIgnoreCase("-updatespell")) {
                this.updateSpellDict = true;
            } else if (args[i].equalsIgnoreCase("-noupdatespell")) {
                this.updateSpellDict = false;
            } else if (args[i].equalsIgnoreCase("-buildlazy")) {
                this.buildLazyFiles = true;
            } else if (args[i].equalsIgnoreCase("-nobuildlazy")) {
                this.buildLazyFiles = false;
            } else if (args[i].equalsIgnoreCase("-skipindexing")) {
                this.skipIndexing = true;
            } else if (args[i].equalsIgnoreCase("-validate")) {
                this.validate = true;
            } else if (args[i].equalsIgnoreCase("-novalidate")) {
                this.validate = false;
            } else if (args[i].equalsIgnoreCase("-rotate")) {
                this.rotate = true;
            } else if (args[i].equalsIgnoreCase("-norotate")) {
                this.rotate = false;
            } else if (args[i].equalsIgnoreCase("-trace")) {
                if (++i >= args.length) {
                    return -1;
                }
                String traceLevelStr = args[i];
                this.traceLevel = traceLevelStr.equalsIgnoreCase("warnings") ? 2 : (traceLevelStr.equalsIgnoreCase("info") ? 4 : (traceLevelStr.equalsIgnoreCase("debug") ? 8 : 1));
            } else {
                Trace.error("Unrecognized command-line parameter: " + args[i]);
                return -1;
            }
            if (gotIdxName) {
                ++i;
                break;
            }
            ++i;
        }
        if (!gotIdxName) {
            return -1;
        }
        return i;
    }
}

