/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine.freeform;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.cdlib.xtf.textEngine.freeform.FreeformQueryParserConstants;
import org.cdlib.xtf.textEngine.freeform.FreeformQueryParserTokenManager;
import org.cdlib.xtf.textEngine.freeform.ParseException;
import org.cdlib.xtf.textEngine.freeform.SimpleCharStream;
import org.cdlib.xtf.textEngine.freeform.Token;

public class FreeformQueryParser
implements FreeformQueryParserConstants {
    public FreeformQueryParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[9];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static {
        FreeformQueryParser.jj_la1_0();
    }

    public static void main(String[] args) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("Enter query: ");
            String text = in.readLine();
            if (text == null || text.length() == 0) break;
            FreeformQueryParser parser = new FreeformQueryParser(new StringReader(text));
            try {
                FNode query = parser.Query();
                System.out.println(query.toXML());
            }
            catch (ParseException e) {
                System.out.println("Parse error: " + e);
            }
        }
    }

    public final FNode Term() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new FNode("term", this.token.image);
    }

    public final FNode Phrase() throws ParseException {
        FNode phrase;
        block17: {
            phrase = new FNode("phrase");
            this.jj_consume_token(5);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 22: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block17;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 22: {
                        FNode term = this.Term();
                        phrase.add(term);
                        continue block16;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                continue block16;
                            }
                            case 2: {
                                this.jj_consume_token(2);
                                continue block16;
                            }
                            case 3: {
                                this.jj_consume_token(3);
                                continue block16;
                            }
                            case 4: {
                                this.jj_consume_token(4);
                                continue block16;
                            }
                            case 6: {
                                this.jj_consume_token(6);
                                continue block16;
                            }
                            case 7: {
                                this.jj_consume_token(7);
                                continue block16;
                            }
                            case 8: {
                                this.jj_consume_token(8);
                                continue block16;
                            }
                        }
                        this.jj_la1[2] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                break;
            }
            this.jj_la1[3] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(5);
        return phrase;
    }

    public final FNode Not() throws ParseException {
        this.jj_consume_token(3);
        FNode kid = this.Component();
        if (kid.name == "not") {
            assert (kid.children.size() == 1);
            return kid.children.get(0);
        }
        FNode node = new FNode("not");
        node.add(kid);
        return node;
    }

    public final FNode ParenSeq() throws ParseException {
        this.jj_consume_token(7);
        FNode node = this.SubQuery();
        this.jj_consume_token(8);
        return node;
    }

    public final FNode Component() throws ParseException {
        FNode node;
        String field = null;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(4);
        }
        while (this.jj_2_1(2)) {
            node = this.Term();
            this.jj_consume_token(6);
            field = node.text;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                node = this.Phrase();
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: {
                node = this.Term();
                break;
            }
            case 7: {
                node = this.ParenSeq();
                break;
            }
            case 3: {
                node = this.Not();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (field != null) {
            node.field = field;
        }
        return node;
    }

    public final FNode ORs() throws ParseException {
        FNode node = new FNode("or");
        FNode kid = this.Component();
        node.add(kid);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(2);
            kid = this.Component();
            node.add(kid);
        }
        return node.promoteSingle();
    }

    public final FNode ANDs() throws ParseException {
        FNode node = new FNode("and");
        FNode kid = this.ORs();
        node.add(kid);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block6;
                }
            }
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(1);
            }
            kid = this.ORs();
            node.add(kid);
        }
        return node.promoteSingle();
    }

    public final FNode SubQuery() throws ParseException {
        FNode node = this.ANDs();
        return node;
    }

    public final FNode Query() throws ParseException {
        FNode sub = this.SubQuery();
        sub.resolveFields(0);
        FNode query = new FNode("query");
        query.add(sub);
        query.fixNots();
        return query;
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(9)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(11)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(12)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(13)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(14)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(15)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(16)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(22)) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_7()) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{4324864, 4325342, 478, 4325342, 16, 4325032, 4, 4325050, 2};
    }

    public FreeformQueryParser(InputStream stream) {
        this(stream, null);
    }

    public FreeformQueryParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new FreeformQueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 9) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 9) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public FreeformQueryParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FreeformQueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 9) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 9) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public FreeformQueryParser(FreeformQueryParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 9) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(FreeformQueryParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 9) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[25];
        int i = 0;
        while (i < 25) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 9) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 25) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 1) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    public class FNode {
        public String name;
        public String text;
        public String field;
        public ArrayList<FNode> children = new ArrayList();

        FNode(String n) {
            this.name = n;
        }

        FNode(String n, String t) {
            this.name = n;
            this.text = t;
        }

        public String toXML() {
            StringBuffer buf = new StringBuffer();
            this.toXML(0, buf);
            return buf.toString();
        }

        private void toXML(int level, StringBuffer buf) {
            buf.append(String.valueOf(this.indent(level)) + "<" + this.name);
            if (this.field != null) {
                buf.append(" field=\"" + this.field + "\"");
            }
            if (this.text != null && this.children.isEmpty()) {
                buf.append(">" + this.text + "</" + this.name + ">\n");
            } else {
                buf.append(">\n");
                ++level;
                if (this.text != null) {
                    buf.append(String.valueOf(this.indent(level)) + this.text + "\n");
                }
                for (FNode kid : this.children) {
                    kid.toXML(level, buf);
                }
                buf.append(String.valueOf(this.indent(--level)) + "</" + this.name + ">\n");
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(String.valueOf(this.name) + "(");
            if (this.field != null) {
                buf.append(String.valueOf(this.field) + ": ");
            }
            if (this.text != null) {
                buf.append("\"" + this.text + "\"");
            }
            boolean first = true;
            for (FNode kid : this.children) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                buf.append(kid.toString());
            }
            buf.append(")");
            return buf.toString();
        }

        private String indent(int level) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < level) {
                buf.append("  ");
                ++i;
            }
            return buf.toString();
        }

        private void add(FNode n) {
            this.children.add(n);
        }

        private FNode promoteSingle() {
            if (this.children.size() == 1) {
                return this.children.get(0);
            }
            return this;
        }

        private void clearFields() {
            this.field = null;
            for (FNode kid : this.children) {
                kid.clearFields();
            }
        }

        private void resolveFields(int level) {
            String f = null;
            if (this.field != null) {
                for (FNode kid : this.children) {
                    kid.clearFields();
                }
            } else {
                for (FNode kid : this.children) {
                    if (kid.field != null) {
                        f = kid.field;
                        continue;
                    }
                    if (f == null) continue;
                    kid.field = f;
                }
                if (f != null) {
                    boolean anyDiff = false;
                    for (FNode kid : this.children) {
                        if (f.equals(kid.field)) continue;
                        anyDiff = true;
                    }
                    if (!anyDiff) {
                        for (FNode kid : this.children) {
                            kid.field = null;
                        }
                        this.field = f;
                    } else {
                        for (FNode kid : this.children) {
                            if (kid.field != null) continue;
                            kid.field = "serverChoice";
                        }
                    }
                }
                for (FNode kid : this.children) {
                    kid.resolveFields(level + 1);
                }
            }
            if (level == 0 && this.field == null && f == null) {
                this.field = "serverChoice";
            }
        }

        private void fixNots() {
            for (FNode kid : this.children) {
                kid.fixNots();
            }
            int i = 0;
            while (i < this.children.size()) {
                FNode kid = this.children.get(i);
                if (kid.name.equals("not")) {
                    if (!this.name.equals("and") && !this.name.equals("query")) {
                        this.name = "and";
                    }
                    boolean found = false;
                    for (FNode k2 : this.children) {
                        if (k2 == kid || k2.name == "not" || k2.field != kid.field) continue;
                        found = true;
                    }
                    if (!found) {
                        FNode all = new FNode("allDocs");
                        FNode and = new FNode("and");
                        and.add(all);
                        and.add(kid);
                        this.children.set(i, and);
                    }
                }
                ++i;
            }
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

