/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.cdlib.xtf.textEngine.XtfQueryRewriter;
import org.cdlib.xtf.util.WordMap;

public class PluralFoldingRewriter
extends XtfQueryRewriter {
    private WordMap pluralMap;
    private Set tokenizedFields;

    public PluralFoldingRewriter(WordMap pluralMap, Set tokFields) {
        this.pluralMap = pluralMap;
        this.tokenizedFields = tokFields;
    }

    protected Query rewrite(TermQuery q) {
        return q;
    }

    protected Query rewrite(SpanTermQuery q) {
        Term t = q.getTerm();
        if (!this.tokenizedFields.contains(t.field())) {
            return q;
        }
        String mapped = this.pluralMap.lookup(t.text());
        if (mapped == null) {
            return q;
        }
        Term newTerm = new Term(t.field(), mapped);
        return this.copyBoost(q, new SpanTermQuery(newTerm, q.getTermLength()));
    }
}

