/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.crossQuery.raw;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.SocketException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.stream.StreamSource;
import org.cdlib.xtf.crossQuery.CrossQuery;
import org.cdlib.xtf.crossQuery.CrossQueryConfig;
import org.cdlib.xtf.servletBase.RedirectException;
import org.cdlib.xtf.servletBase.TextConfig;
import org.cdlib.xtf.textEngine.QueryProcessor;
import org.cdlib.xtf.textEngine.QueryRequest;
import org.cdlib.xtf.textEngine.QueryRequestParser;
import org.cdlib.xtf.textEngine.QueryResult;
import org.cdlib.xtf.util.AttribList;

public class RawQuery
extends CrossQuery {
    protected TextConfig readConfig(String configPath) {
        this.config = new RawQueryConfig(this);
        return this.config;
    }

    public String getConfigName() {
        return "no config file";
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try {
            res.setContentType("text/xml");
            req.setAttribute("org.cdlib.xtf.servlet.raw", (Object)"1");
            this.apply(req, res);
        }
        catch (Exception e) {
            if (!(e instanceof SocketException)) {
                try {
                    this.genErrorPage(req, res, e);
                }
                catch (RedirectException redirectException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public String getServletInfo() {
        return "rawQuery search servlet";
    }

    protected void apply(HttpServletRequest req, HttpServletResponse res) throws Exception {
        long startTime = System.currentTimeMillis();
        String queryText = req.getParameter("query");
        if (queryText == null || queryText.length() == 0) {
            throw new RuntimeException("'query' parameter must be specified");
        }
        QueryRequest queryReq = new QueryRequestParser().parseRequest(new StreamSource(new StringReader(queryText)), new File(this.getRealPath("")));
        queryReq.parserInput = null;
        queryReq.parserOutput = queryText;
        QueryProcessor proc = this.createQueryProcessor();
        QueryResult queryResult = proc.processRequest(queryReq);
        this.formatHits("crossQueryResult", req, res, new AttribList(), queryReq, queryResult, startTime);
    }

    private class RawQueryConfig
    extends CrossQueryConfig {
        RawQueryConfig(RawQuery servlet) {
            super(servlet);
        }
    }
}

