/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.spelt.SpellReader;
import org.apache.lucene.spelt.SpellWriter;
import org.apache.lucene.util.ProgressTracker;
import org.apache.lucene.util.StringUtil;

public class SpellTestCmdLine {
    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        System.out.println("\n*** Spelt command-line test utility ***\n");
        if (args.length < 3) {
            SpellTestCmdLine.printUsageAndExit();
        }
        try {
            int alg = 2;
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-build") && i + 3 <= args.length) {
                    SpellTestCmdLine.buildDictionary(alg, args[i + 1], args[i + 2]);
                    i += 2;
                } else if (args[i].equals("-test") && i + 3 <= args.length) {
                    SpellTestCmdLine.testDictionary(alg, args[i + 1], args[i + 2]);
                    i += 2;
                } else {
                    SpellTestCmdLine.printUsageAndExit();
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.out.flush();
            System.err.println("Unexpected exception during spellcheck: " + e);
            e.printStackTrace(System.err);
        }
        long elapsed = System.currentTimeMillis() - startTime;
        System.out.println("Done. Total time: " + (float)elapsed / 1000.0f + " sec");
    }

    private static void printUsageAndExit() {
        System.err.println("Usage:  java -jar spelt.jar -build <src-files-dir> <dictionary-dir>\n   or:  java -jar spelt.jar -test <test-queries-file> <dictionary-dir>\n\n where  <test-queries-file> contains one or more lines like this\n        misspelled phrase\n   or   misspelled phrase -> correct phrase 1|correct phrase 2|...\n");
        System.exit(1);
    }

    private static void buildDictionary(int alg, String srcDir, String dictDir) throws IOException {
        File dictDirFile = new File(dictDir);
        if (dictDirFile.isDirectory()) {
            File[] fileArray = dictDirFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
            if (!dictDirFile.delete()) {
                throw new IOException("Error deleting old dictionary from '" + dictDir + "'");
            }
        }
        DictBuilder builder = alg == 0 ? new DictBuilder(null, null) : (alg == 2 ? new SpeltDictBuilder(dictDirFile) : null);
        System.out.println("Ripping text and adding to dictionary...");
        TextRipper ripper = new TextRipper(srcDir);
        builder.add(ripper);
        System.out.println("Finishing dictionary...");
        ProgressTracker prog = new ProgressTracker(){

            public void report(int pctDone, String descrip) {
                String pctTxt = Integer.toString(pctDone);
                while (pctTxt.length() < 3) {
                    pctTxt = " " + pctTxt;
                }
                System.out.println("[" + pctTxt + "%] " + descrip);
            }
        };
        prog.setMinInterval(3000);
        builder.finish(prog);
    }

    private static void testDictionary(int alg, String testFile, String dictDir) throws IOException {
        String line;
        SpeltSuggTester suggTester = alg == 2 ? new SpeltSuggTester(dictDir) : null;
        BufferedReader lineReader = new BufferedReader(new FileReader(testFile));
        int nTried = 0;
        int nCorrect = 0;
        while ((line = lineReader.readLine()) != null && (line = line.replaceFirst(";.*", "").trim()).length() != 0) {
            String s;
            String[] parts = line.split("->");
            if (parts.length != 1 && parts.length != 2) {
                System.out.println("Unrecognized test line: " + line);
                continue;
            }
            String origPhrase = parts[0].trim();
            String[] correctPhrases = parts.length == 1 ? null : parts[1].trim().split("\\|");
            System.out.println("Incorrect phrase: " + origPhrase);
            String[] origWords = StringUtil.splitWords(origPhrase);
            Object[] suggWords = suggTester.suggest(origWords);
            String suggPhrase = StringUtil.join(suggWords);
            System.out.println("Suggested phrase: " + suggPhrase);
            ++nTried;
            if (correctPhrases == null) continue;
            boolean found = false;
            String[] stringArray = correctPhrases;
            int n = correctPhrases.length;
            int n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                found |= s.trim().equalsIgnoreCase(suggPhrase);
                ++n2;
            }
            if (found) {
                System.out.println("--> CORRECT");
                ++nCorrect;
                continue;
            }
            System.out.println("--> INCORRECT. Answer should have been:");
            stringArray = correctPhrases;
            n = correctPhrases.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                System.out.println("    " + s);
                ++n2;
            }
        }
        System.out.println();
        System.out.printf("TOTAL: %d correct out of %d tried = %.1f%%\n", nCorrect, nTried, (double)nCorrect * 100.0 / (double)nTried);
        System.out.println();
        suggTester.close();
    }

    private static HashSet makeStopSet() {
        HashSet<String> stopSet = new HashSet<String>();
        String[] stopWords = StringUtil.splitWords("a an and are as at be but by for if in into is it no not of on or s such t that the their then there these they this to was will with");
        int i = 0;
        while (i < stopWords.length) {
            stopSet.add(stopWords[i]);
            ++i;
        }
        return stopSet;
    }

    private static class DictBuilder {
        private DictBuilder() {
        }

        void add(Iterator words) throws IOException {
            while (words.hasNext()) {
                words.next();
            }
        }

        void finish(ProgressTracker prog) throws IOException {
        }

        /* synthetic */ DictBuilder(DictBuilder dictBuilder, DictBuilder dictBuilder2) {
            this();
        }
    }

    private static class SpeltDictBuilder
    extends DictBuilder {
        SpellWriter spellWriter;

        SpeltDictBuilder(File dictDir) throws IOException {
            this.spellWriter = SpellWriter.open(dictDir);
            this.spellWriter.setStopwords(SpellTestCmdLine.makeStopSet());
        }

        void add(Iterator words) throws IOException {
            while (words.hasNext()) {
                this.spellWriter.queueWord((String)words.next());
            }
        }

        void finish(ProgressTracker prog) throws IOException {
            this.spellWriter.flushQueuedWords(prog);
            this.spellWriter.close();
        }
    }

    private static class SpeltSuggTester
    implements SuggTester {
        SpellReader spellReader;

        SpeltSuggTester(String dictDir) throws IOException {
            this.spellReader = SpellReader.open(new File(dictDir));
            this.spellReader.setStopwords(SpellTestCmdLine.makeStopSet());
        }

        public String[] suggest(String[] origPhrase) throws IOException {
            return this.spellReader.suggestKeywords(origPhrase);
        }

        public void close() throws IOException {
            this.spellReader.close();
        }
    }

    private static interface SuggTester {
        public String[] suggest(String[] var1) throws IOException;

        public void close() throws IOException;
    }

    private static class TextRipper
    implements Iterator {
        Stack fileStack = new Stack();
        BufferedReader reader;
        boolean more = true;
        String line;
        Matcher words = null;
        Pattern wordPat = Pattern.compile("\\w+('\\w+)?");
        final Pattern xmlPat = Pattern.compile("<[^<]*>");

        TextRipper(String dir) throws IOException {
            this.fileStack.push(new File(dir));
            this.advance();
        }

        boolean nextFile() throws IOException {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            while (this.reader == null && !this.fileStack.isEmpty()) {
                File file = (File)this.fileStack.pop();
                if (file.isFile()) {
                    String path = file.getCanonicalPath();
                    if (!path.matches(".*\\.(xml|txt|text|html|htm|xhtml)")) continue;
                    System.out.println(file);
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    continue;
                }
                if (!file.isDirectory()) continue;
                File[] subFiles = file.listFiles();
                int i = 0;
                while (i < subFiles.length) {
                    this.fileStack.push(subFiles[i]);
                    ++i;
                }
            }
            return this.reader != null;
        }

        void advance() throws IOException {
            while (this.more) {
                if (this.reader == null && !this.nextFile()) {
                    this.more = false;
                    break;
                }
                if (this.words != null && this.words.find()) break;
                this.line = this.reader.readLine();
                if (this.line == null) {
                    this.reader.close();
                    this.reader = null;
                    continue;
                }
                this.line = this.stripXML(this.line);
                this.words = this.wordPat.matcher(this.line);
            }
        }

        String stripXML(String line) {
            if (line.indexOf(60) < 0) {
                return line;
            }
            return this.xmlPat.matcher(line).replaceAll("");
        }

        public boolean hasNext() {
            return this.more;
        }

        public Object next() {
            String ret = this.line.substring(this.words.start(), this.words.end());
            try {
                this.advance();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

