/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.util.ByteArrayInput;
import org.apache.xindice.xml.NodeSource;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.XMLCompressedInput;
import org.apache.xindice.xml.dom.AttrImpl;
import org.apache.xindice.xml.dom.ContainerNodeImpl;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.apache.xindice.xml.dom.NamedNodeMapImpl;
import org.apache.xindice.xml.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public final class ElementImpl
extends ContainerNodeImpl
implements Element {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$xml$dom$ElementImpl == null ? (class$org$apache$xindice$xml$dom$ElementImpl = ElementImpl.class$("org.apache.xindice.xml.dom.ElementImpl")) : class$org$apache$xindice$xml$dom$ElementImpl));
    private NamedNodeMapImpl attributes;
    private short symbolID;
    static /* synthetic */ Class class$org$apache$xindice$xml$dom$ElementImpl;

    public ElementImpl() {
        this.attributes = new NamedNodeMapImpl(this);
        this.symbolID = (short)-1;
    }

    public ElementImpl(NodeImpl parentNode, byte[] data, int pos, int len) {
        block2: {
            super(parentNode, data, pos, len);
            this.attributes = new NamedNodeMapImpl(this);
            this.symbolID = (short)-1;
            DocumentImpl doc = (DocumentImpl)this.getOwnerDocument();
            try {
                this.loadAttributes(doc.getSymbols());
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public ElementImpl(NodeImpl parentNode, boolean dirty) {
        super(parentNode, dirty);
        this.attributes = new NamedNodeMapImpl(this);
        this.symbolID = (short)-1;
    }

    public ElementImpl(NodeImpl parentNode, String nodeName) {
        super(parentNode, true);
        this.attributes = new NamedNodeMapImpl(this);
        this.symbolID = (short)-1;
        this.nodeName = nodeName;
    }

    protected boolean isNodeTypeValid(short type) {
        return type == 1 || type == 8 || type == 3 || type == 4 || type == 5;
    }

    protected void checkLoaded() {
        block4: {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            try {
                if (this.data != null) {
                    DocumentImpl doc = (DocumentImpl)this.getOwnerDocument();
                    SymbolTable st = doc.getSymbols();
                    ByteArrayInput bis = new ByteArrayInput(this.data, this.pos, this.len);
                    XMLCompressedInput in = new XMLCompressedInput(bis, st);
                    in.readSignature();
                    in.readContentSize();
                    this.symbolID = in.readShort();
                    SymbolTable.SymbolInfo si = st.getSymbolInfo(this.symbolID);
                    this.nodeName = si.getQName();
                    this.nsURI = si.getNamespaceURI();
                    this.loadChildren(st);
                }
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public short getSymbolID() {
        return this.symbolID;
    }

    public void expandSource() {
        NodeSource src = this.getSource();
        if (src != null) {
            String prefix = this.sourcePrefix("src", "http://xml.apache.org/xindice/Query");
            this.setAttribute("xmlns:" + prefix, "http://xml.apache.org/xindice/Query");
            this.setAttribute(prefix + ":" + "col", src.getCollection().getCanonicalName());
            Key k = src.getKey();
            if (k != null) {
                this.setAttribute(prefix + ":" + "key", k.toString());
            }
        }
    }

    private String sourcePrefix(String candidatePrefix, String nsuri) {
        ElementImpl element = this;
        HashSet<String> prefixes = new HashSet<String>();
        while (element != null) {
            NamedNodeMap nm = element.getAttributes();
            int i = 0;
            while (i < nm.getLength()) {
                Attr a = (Attr)nm.item(i);
                String name = a.getNodeName();
                if (name.startsWith("xmlns:")) {
                    String prefix = name.substring(6);
                    if (nsuri.equals(a.getValue())) {
                        return prefix;
                    }
                    prefixes.add(prefix);
                }
                ++i;
            }
            Element element2 = element = element.getParentNode().getNodeType() == 1 ? (Element)element.getParentNode() : null;
        }
        String result = candidatePrefix;
        while (prefixes.contains(result)) {
            result = candidatePrefix + System.currentTimeMillis();
        }
        return result;
    }

    protected void loadAttributes(SymbolTable st) throws IOException {
        ByteArrayInput bis = new ByteArrayInput(this.data, this.pos, this.len);
        XMLCompressedInput in = new XMLCompressedInput(bis, st);
        in.readSignature();
        in.readContentSize();
        in.readShort();
        int attrCount = in.readAttributeCount();
        int i = 0;
        while (i < attrCount) {
            short symbol = in.readShort();
            short strLen = in.readShort();
            byte[] b = new byte[strLen];
            in.read(b);
            SymbolTable.SymbolInfo si = st.getSymbolInfo(symbol);
            String name = si.getQName();
            String nsURI = si.getNamespaceURI();
            AttrImpl attr = new AttrImpl(this, name, nsURI, symbol, new String(b, "UTF-8"));
            this.attributes.setNamedItem(attr);
            ++i;
        }
    }

    public short getNodeType() {
        return 1;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.getNamedItem(name) != null;
    }

    public void removeAttribute(String name) throws DOMException {
        this.checkReadOnly();
        AttrImpl attr = (AttrImpl)this.attributes.removeNamedItem(name);
        if (attr != null) {
            attr.setParentNode((NodeImpl)((Object)this.getOwnerDocument()));
        }
        this.setDirty();
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public String getAttribute(String name) {
        Attr attr = (Attr)this.attributes.getNamedItem(name);
        return attr != null ? attr.getValue() : "";
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        this.checkReadOnly();
        Attr oldAttr = (Attr)this.attributes.getNamedItem(newAttr.getName());
        DocumentImpl doc = (DocumentImpl)this.getOwnerDocument();
        if (newAttr.getParentNode().getNodeType() == 1) {
            throw NodeImpl.EX_INUSE_ATTRIBUTE;
        }
        if (doc != newAttr.getOwnerDocument()) {
            throw NodeImpl.EX_WRONG_DOCUMENT;
        }
        ((AttrImpl)newAttr).setParentNode(this);
        this.attributes.setNamedItem(newAttr);
        this.setDirty();
        return oldAttr;
    }

    public void setAttribute(String name, String value) throws DOMException {
        Attr attr = this.getOwnerDocument().createAttribute(name);
        attr.setValue(value);
        this.setAttributeNode(attr);
    }

    public Attr getAttributeNode(String name) {
        return (Attr)this.attributes.getNamedItem(name);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        this.checkReadOnly();
        if (oldAttr.getParentNode() != this) {
            throw NodeImpl.EX_NOT_FOUND;
        }
        this.attributes.remove(oldAttr.getName());
        ((AttrImpl)oldAttr).setParentNode((NodeImpl)((Object)this.getOwnerDocument()));
        this.setDirty();
        return oldAttr;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        Attr attr = (Attr)this.attributes.getNamedItemNS(namespaceURI, localName);
        return attr != null ? attr.getValue() : "";
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        Attr attr = this.getOwnerDocument().createAttributeNS(namespaceURI, qualifiedName);
        attr.setValue(value);
        this.setAttributeNodeNS(attr);
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        this.checkReadOnly();
        AttrImpl attr = (AttrImpl)this.attributes.removeNamedItemNS(namespaceURI, localName);
        if (attr != null) {
            attr.setParentNode((NodeImpl)((Object)this.getOwnerDocument()));
        }
        this.setDirty();
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return (Attr)this.attributes.getNamedItemNS(namespaceURI, localName);
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        return this.setAttributeNode(newAttr);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.attributes.getNamedItemNS(namespaceURI, localName) != null;
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    public boolean isEqualNode(Node other) {
        if (!super.isEqualNode(other)) {
            return false;
        }
        if (!this.hasAttributes() && !other.hasAttributes()) {
            return true;
        }
        if (!this.hasAttributes() || !other.hasAttributes()) {
            return false;
        }
        NamedNodeMap attrMap = this.getAttributes();
        NamedNodeMap otherAttrMap = other.getAttributes();
        if (attrMap.getLength() != otherAttrMap.getLength()) {
            return false;
        }
        int i = 0;
        while (i < attrMap.getLength()) {
            String name = attrMap.item(i).getNodeName();
            Node attr = otherAttrMap.getNamedItem(name);
            if (attr == null || !attrMap.item(i).getNodeValue().equals(attr.getNodeValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    Node renameNode(String namespaceURI, String qualifiedName, String prefix) throws DOMException {
        this.checkLoaded();
        this.checkReadOnly();
        this.nodeName = qualifiedName;
        if (prefix != null) {
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespaceURI);
            this.nsURI = namespaceURI;
        } else {
            this.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + this.nsURI);
            this.nsURI = null;
        }
        this.invokeHandlers((short)4, this, null);
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

