/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.server.rpc;

import java.util.Hashtable;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.Database;
import org.apache.xindice.server.rpc.RPCMessage;
import org.apache.xmlrpc.XmlRpcException;
import org.xmldb.api.base.XMLDBException;

public abstract class RPCDefaultMessage
implements RPCMessage {
    public static final String API_NAME = "Xindice XML-RPC";
    public static final String API_VERSION = "0.1";
    public static final String RESULT = "result";
    public static final String NAME = "name";
    public static final String COLLECTION = "collection";
    public static final String DOCUMENT = "document";
    public static final String COMPRESSED = "compressed";
    public static final String TIMESTAMP = "timestamp";
    public static final String PATTERN = "pattern";
    public static final String MAXKEYSIZE = "maxkeysize";
    public static final String PAGESIZE = "pagesize";
    public static final String TYPE = "type";
    public static final String QUERY = "query";
    public static final String NAMESPACES = "namespaces";
    public static final String CONFIGURATION = "configuration";
    public static final String META = "meta";
    public static final String MISSING_COLLECTION_PARAM = "Required parameter 'collection' not found.";
    public static final String MISSING_NAME_PARAM = "Required parameter 'name' not found.";
    public static final String MISSING_DOCUMENT_PARAM = "Required parameter 'document' not found.";
    public static final String MISSING_PATTERN_PARAM = "Required parameter 'pattern' not found.";
    public static final String MISSING_TYPE_PARAM = "Required parameter 'type' not found.";
    public static final String MISSING_QUERY_PARAM = "Required parameter 'query' not found.";
    public static final String MISSING_TIMESTAMP_PARAM = "For compressed results a timestamp must be provided.";
    public static final String MISSING_CONFIGURATION_PARAM = "You must either provide a document containing the configuration or specify the 'name' and 'patter' parameters.";
    public static final String MISSING_META_CONFIGURATION = "Meta information requested but not enabled";
    public static final String MISSING_META_PARAM = "Required parameter 'meta' not found";

    protected Collection getCollection(String name) throws XmlRpcException, XMLDBException, DBException {
        while (name.endsWith("/")) {
            name = name.substring(0, name.lastIndexOf("/"));
        }
        if (name.startsWith("/")) {
            Database db;
            int colIndex = name.indexOf(47, 1);
            String dbName = name.substring(1);
            String colName = "/";
            if (colIndex != -1) {
                dbName = name.substring(1, colIndex);
                colName = name.substring(colIndex + 1);
            }
            if ((db = Database.getDatabase(dbName)) == null) {
                throw new XMLDBException(400, "Database '" + dbName + "' could not be found");
            }
            Collection col = db.getCollection(colName);
            if (col == null) {
                throw new XMLDBException(200, "Collection '" + colName + "' could not be found");
            }
            return col;
        }
        throw new XMLDBException(5, "Collection name must begin with a '/'");
    }

    public abstract Hashtable execute(Hashtable var1) throws Exception;
}

