/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.db.VerifyConfig;
import com.sleepycat.db.XmlHelper;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.dbxml.NativeXmlInputStream;
import com.sleepycat.dbxml.XmlContainer;
import com.sleepycat.dbxml.XmlContainerConfig;
import com.sleepycat.dbxml.XmlDocument;
import com.sleepycat.dbxml.XmlDocumentConfig;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlIndexLookup;
import com.sleepycat.dbxml.XmlInputStream;
import com.sleepycat.dbxml.XmlManagerConfig;
import com.sleepycat.dbxml.XmlModify;
import com.sleepycat.dbxml.XmlQueryContext;
import com.sleepycat.dbxml.XmlQueryExpression;
import com.sleepycat.dbxml.XmlResolver;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlTransaction;
import com.sleepycat.dbxml.XmlUpdateContext;
import com.sleepycat.dbxml.XmlValue;
import com.sleepycat.dbxml.dbxml_javaJNI;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class XmlManager {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private Environment dbenv;
    private XmlContainerConfig defaultConfig;
    private boolean threaded = true;
    private boolean adopted = false;
    private XmlManagerConfig config = null;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARNING = 4;
    public static final int LEVEL_ERROR = 8;
    public static final int LEVEL_ALL = -1;
    public static final int CATEGORY_NONE = 0;
    public static final int CATEGORY_INDEXER = 1;
    public static final int CATEGORY_QUERY = 2;
    public static final int CATEGORY_OPTIMIZER = 4;
    public static final int CATEGORY_DICTIONARY = 8;
    public static final int CATEGORY_CONTAINER = 16;
    public static final int CATEGORY_NODESTORE = 32;
    public static final int CATEGORY_MANAGER = 64;
    public static final int CATEGORY_ALL = -1;
    public static final String metaDataNamespace_uri = "http://www.sleepycat.com/2002/dbxml";
    public static final String metaDataNamespace_prefix = "dbxml";
    public static final String metaDataName_name = "name";
    public static final String metaDataName_root = "root";

    protected XmlManager(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(XmlManager obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public void delete() {
        this.closeInternal();
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            dbxml_javaJNI.delete_XmlManager(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public XmlManager(Environment dbenv, XmlManagerConfig config) throws XmlException {
        this(dbxml_javaJNI.new_XmlManager(XmlHelper.getDbEnv(dbenv), config == null ? 0 : config.makeFlags()), true);
        this.dbenv = dbenv;
        this.config = config;
        if (config != null && config.getAdoptEnvironment()) {
            this.adopted = true;
        }
        try {
            this.threaded = (XmlHelper.getDbEnv(dbenv).get_open_flags() & 0x80) != 0;
        }
        catch (DatabaseException de) {
            throw new XmlException(5, de.toString(), de, de.getErrno(), 0, 0);
        }
    }

    public XmlManager(XmlManagerConfig config) throws XmlException, FileNotFoundException {
        DbEnv newEnv = null;
        try {
            newEnv = new DbEnv(0);
            newEnv.set_cachesize(0x4000000L, 1);
            newEnv.set_errpfx("BDB XML");
            newEnv.open(null, 0x880081, 0);
            this.dbenv = XmlHelper.makeNewEnvironment(newEnv);
        }
        catch (DatabaseException de) {
            throw new XmlException(5, de.toString(), de, de.getErrno(), 0, 0);
        }
        this.adopted = true;
        this.config = config;
        int flags = config == null ? 0 : config.makeFlags();
        this.swigCPtr = dbxml_javaJNI.new_XmlManager(newEnv, flags);
        this.swigCMemOwn = true;
    }

    public XmlManager() throws XmlException, FileNotFoundException {
        this(null);
    }

    public Environment getEnvironment() throws XmlException {
        return this.dbenv;
    }

    public XmlManagerConfig getManagerConfig() throws XmlException {
        return this.config;
    }

    public void setDefaultContainerConfig(XmlContainerConfig config) throws XmlException {
        this.defaultConfig = config;
    }

    public XmlContainerConfig getDefaultContainerConfig() throws XmlException {
        return this.defaultConfig;
    }

    public XmlUpdateContext createUpdateContext() throws XmlException {
        return new XmlUpdateContext(this);
    }

    public XmlQueryContext createQueryContext() throws XmlException {
        XmlQueryContext xqc = new XmlQueryContext(0, 0);
        xqc.mgr = this;
        return xqc;
    }

    public XmlQueryContext createQueryContext(int rt, int et) throws XmlException {
        XmlQueryContext xqc = new XmlQueryContext(rt, et);
        xqc.mgr = this;
        return xqc;
    }

    public XmlQueryContext createQueryContext(int rt) throws XmlException {
        XmlQueryContext xqc = new XmlQueryContext(rt, 0);
        xqc.mgr = this;
        return xqc;
    }

    public XmlInputStream createInputStream(InputStream is) throws XmlException {
        return new NativeXmlInputStream(is);
    }

    public XmlContainer createContainer(String name) throws XmlException {
        return this.createContainer(name, this.defaultConfig);
    }

    public XmlContainer createContainer(XmlTransaction txn, String name) throws XmlException {
        return this.createContainer(txn, name, this.defaultConfig);
    }

    public XmlContainer openContainer(String name) throws XmlException {
        return this.openContainer(name, this.defaultConfig);
    }

    public XmlContainer openContainer(XmlTransaction txn, String name) throws XmlException {
        return this.openContainer(txn, name, this.defaultConfig);
    }

    public XmlContainer createContainer(String name, XmlContainerConfig config) throws XmlException {
        int containerType;
        int flags = 0;
        if (config != null) {
            flags = config.makeFlags(this.threaded);
            containerType = config.getNodeContainer() ? 1 : 0;
        } else {
            containerType = this.getDefaultContainerType();
        }
        XmlContainer cont = this.createContainer(name, flags, containerType, 0);
        cont.setContainerConfig(config);
        cont.setManager(this);
        return cont;
    }

    public XmlContainer createContainer(XmlTransaction txn, String name, XmlContainerConfig config) throws XmlException {
        int containerType;
        int flags = 0;
        if (config != null) {
            flags = config.makeFlags(this.threaded);
            containerType = config.getNodeContainer() ? 1 : 0;
        } else {
            containerType = this.getDefaultContainerType();
        }
        XmlContainer cont = this.createContainer(txn, name, flags, containerType, 0);
        cont.setContainerConfig(config);
        cont.setManager(this);
        return cont;
    }

    public XmlContainer openContainer(String name, XmlContainerConfig config) throws XmlException {
        int containerType;
        int flags = 0;
        if (config != null) {
            flags = config.makeFlags(this.threaded);
            containerType = config.getNodeContainer() ? 1 : 0;
        } else {
            containerType = this.getDefaultContainerType();
        }
        XmlContainer cont = this.openContainer(name, flags, containerType, 0);
        cont.setContainerConfig(config);
        cont.setManager(this);
        return cont;
    }

    public XmlContainer openContainer(XmlTransaction txn, String name, XmlContainerConfig config) throws XmlException {
        int containerType;
        int flags = 0;
        if (config != null) {
            flags = config.makeFlags(this.threaded);
            containerType = config.getNodeContainer() ? 1 : 0;
        } else {
            containerType = this.getDefaultContainerType();
        }
        XmlContainer cont = this.openContainer(txn, name, flags, containerType, 0);
        cont.setContainerConfig(config);
        cont.setManager(this);
        return cont;
    }

    public XmlTransaction createTransaction(Transaction toUse) throws XmlException {
        XmlTransaction txn = this.createTransaction(XmlHelper.getDbTxn(toUse));
        txn.setTransaction(toUse);
        return txn;
    }

    public XmlTransaction createTransaction(Transaction parent, TransactionConfig config) throws XmlException {
        Transaction newTxn = null;
        try {
            newTxn = this.dbenv.beginTransaction(parent, config);
        }
        catch (DatabaseException de) {
            throw new XmlException(5, de.toString(), de, de.getErrno(), 0, 0);
        }
        return this.createTransaction(newTxn);
    }

    public XmlTransaction createTransaction() throws XmlException {
        return this.createTransaction(null, null);
    }

    public XmlIndexLookup createIndexLookup(XmlContainer cont, String uri, String name, String index, XmlValue value, int op) throws XmlException {
        XmlIndexLookup lookup = this.createIndexLookupInternal(cont, uri, name, index, value, op);
        lookup.container = cont;
        lookup.lowBoundValue = value;
        return lookup;
    }

    public XmlIndexLookup createIndexLookup(XmlContainer cont, String uri, String name, String index, XmlValue value) throws XmlException {
        XmlIndexLookup lookup = this.createIndexLookupInternal(cont, uri, name, index, value);
        lookup.container = cont;
        lookup.lowBoundValue = value;
        return lookup;
    }

    public XmlIndexLookup createIndexLookup(XmlContainer cont, String uri, String name, String index) throws XmlException {
        XmlIndexLookup lookup = this.createIndexLookupInternal(cont, uri, name, index);
        lookup.container = cont;
        return lookup;
    }

    public XmlDocument createDocument() throws XmlException {
        XmlDocument doc = this.createDocumentInternal();
        doc.setManager(this);
        return doc;
    }

    public XmlResults query(String query, XmlQueryContext context, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.query(query, context, flags);
    }

    public XmlResults query(XmlTransaction txn, String query, XmlQueryContext context, XmlDocumentConfig config) throws XmlException {
        int flags = config == null ? 0 : config.makeFlags();
        return this.query(txn, query, context, flags);
    }

    public void reindexContainer(String name, XmlContainerConfig config) throws XmlException {
        this.reindexContainer(name, new XmlUpdateContext(this), config);
    }

    public void reindexContainer(String name, XmlUpdateContext context, XmlContainerConfig config) throws XmlException {
        int flags = 0;
        if (config != null) {
            flags = config.makeFlags(this.threaded);
        }
        this.reindexContainer(name, context, flags);
    }

    public void reindexContainer(XmlTransaction txn, String name, XmlContainerConfig config) throws XmlException {
        this.reindexContainer(txn, name, new XmlUpdateContext(this), config);
    }

    public void reindexContainer(XmlTransaction txn, String name, XmlUpdateContext context, XmlContainerConfig config) throws XmlException {
        int flags = 0;
        if (config != null) {
            flags = config.makeFlags(this.threaded);
        }
        this.reindexContainer(txn, name, context, flags);
    }

    public void verifyContainer(String name, String filename, VerifyConfig config) throws XmlException {
        int flags = 0;
        if (config.getAggressive()) {
            flags |= 1;
        }
        if (config.getSalvage()) {
            flags |= 0x40;
        }
        if (config.getPrintable()) {
            flags |= 0x20;
        }
        if (config.getOrderCheckOnly()) {
            flags |= 4;
        }
        if (config.getNoOrderCheck()) {
            flags |= 2;
        }
        this.verifyContainer(name, filename, flags);
    }

    protected void closeInternal() {
        if (this.adopted) {
            try {
                this.dbenv.close();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        this.adopted = false;
        this.dbenv = null;
        this.config = null;
    }

    public void close() throws XmlException {
        this.delete();
    }

    public XmlManager(DbEnv dbEnv, int flags) throws XmlException {
        this(dbxml_javaJNI.new_XmlManager(dbEnv, flags), true);
    }

    public void setDefaultPageSize(int pageSize) throws XmlException {
        dbxml_javaJNI.XmlManager_setDefaultPageSize(this.swigCPtr, this, pageSize);
    }

    public int getDefaultPageSize() throws XmlException {
        return dbxml_javaJNI.XmlManager_getDefaultPageSize(this.swigCPtr, this);
    }

    public void setDefaultSequenceIncrement(int incr) throws XmlException {
        dbxml_javaJNI.XmlManager_setDefaultSequenceIncrement(this.swigCPtr, this, incr);
    }

    public int getDefaultSequenceIncrement() throws XmlException {
        return dbxml_javaJNI.XmlManager_getDefaultSequenceIncrement(this.swigCPtr, this);
    }

    public void setDefaultContainerType(int type) throws XmlException {
        dbxml_javaJNI.XmlManager_setDefaultContainerType(this.swigCPtr, this, type);
    }

    public int getDefaultContainerType() throws XmlException {
        return dbxml_javaJNI.XmlManager_getDefaultContainerType(this.swigCPtr, this);
    }

    public String getHome() throws XmlException {
        return dbxml_javaJNI.XmlManager_getHome(this.swigCPtr, this);
    }

    public void registerResolver(XmlResolver resolver) throws XmlException {
        dbxml_javaJNI.XmlManager_registerResolver(this.swigCPtr, this, XmlResolver.getCPtr(resolver), resolver);
    }

    public int getImplicitTimezone() throws XmlException {
        return dbxml_javaJNI.XmlManager_getImplicitTimezone(this.swigCPtr, this);
    }

    public void setImplicitTimezone(int tz) throws XmlException {
        dbxml_javaJNI.XmlManager_setImplicitTimezone(this.swigCPtr, this, tz);
    }

    public int existsContainer(String name) throws XmlException {
        return dbxml_javaJNI.XmlManager_existsContainer(this.swigCPtr, this, name);
    }

    public void removeContainer(String name) throws XmlException {
        dbxml_javaJNI.XmlManager_removeContainer__SWIG_0(this.swigCPtr, this, name);
    }

    public void removeContainer(XmlTransaction txn, String name) throws XmlException {
        dbxml_javaJNI.XmlManager_removeContainer__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name);
    }

    public void renameContainer(String oldName, String newName) throws XmlException {
        dbxml_javaJNI.XmlManager_renameContainer__SWIG_0(this.swigCPtr, this, oldName, newName);
    }

    public void renameContainer(XmlTransaction txn, String oldName, String newName) throws XmlException {
        dbxml_javaJNI.XmlManager_renameContainer__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, oldName, newName);
    }

    public void upgradeContainer(String name, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlManager_upgradeContainer(this.swigCPtr, this, name, XmlUpdateContext.getCPtr(uc));
    }

    public void compactContainer(String name, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlManager_compactContainer__SWIG_0(this.swigCPtr, this, name, XmlUpdateContext.getCPtr(uc));
    }

    public void compactContainer(XmlTransaction txn, String name, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlManager_compactContainer__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, XmlUpdateContext.getCPtr(uc));
    }

    public void truncateContainer(String name, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlManager_truncateContainer__SWIG_0(this.swigCPtr, this, name, XmlUpdateContext.getCPtr(uc));
    }

    public void truncateContainer(XmlTransaction txn, String name, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlManager_truncateContainer__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, XmlUpdateContext.getCPtr(uc));
    }

    protected void reindexContainer(String name, XmlUpdateContext uc, int flags) {
        dbxml_javaJNI.XmlManager_reindexContainer__SWIG_0(this.swigCPtr, this, name, XmlUpdateContext.getCPtr(uc), flags);
    }

    protected void reindexContainer(String name, XmlUpdateContext uc) {
        dbxml_javaJNI.XmlManager_reindexContainer__SWIG_1(this.swigCPtr, this, name, XmlUpdateContext.getCPtr(uc));
    }

    protected void reindexContainer(XmlTransaction txn, String name, XmlUpdateContext uc, int flags) {
        dbxml_javaJNI.XmlManager_reindexContainer__SWIG_2(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, XmlUpdateContext.getCPtr(uc), flags);
    }

    protected void reindexContainer(XmlTransaction txn, String name, XmlUpdateContext uc) {
        dbxml_javaJNI.XmlManager_reindexContainer__SWIG_3(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, XmlUpdateContext.getCPtr(uc));
    }

    public XmlInputStream createStdInInputStream() throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createStdInInputStream(this.swigCPtr, this);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createLocalFileInputStream(String filename) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createLocalFileInputStream(this.swigCPtr, this, filename);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createMemBufInputStream(String bytes, long count, String id, boolean adopt) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createMemBufInputStream__SWIG_0(this.swigCPtr, this, bytes, count, id, adopt);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createMemBufInputStream(String bytes, long count, String id) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createMemBufInputStream__SWIG_1(this.swigCPtr, this, bytes, count, id);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createMemBufInputStream(String bytes, long count, boolean copyBuffer) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createMemBufInputStream__SWIG_2(this.swigCPtr, this, bytes, count, copyBuffer);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createURLInputStream(String baseId, String systemId, String publicId) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createURLInputStream__SWIG_0(this.swigCPtr, this, baseId, systemId, publicId);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    public XmlInputStream createURLInputStream(String baseId, String systemId) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createURLInputStream__SWIG_1(this.swigCPtr, this, baseId, systemId);
        return cPtr == 0L ? null : new XmlInputStream(cPtr, false);
    }

    protected XmlContainer createContainer(String name, int flags, int type, int mode) {
        long cPtr = dbxml_javaJNI.XmlManager_createContainer__SWIG_0(this.swigCPtr, this, name, flags, type, mode);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    protected XmlContainer createContainer(String name, int flags, int type) {
        long cPtr = dbxml_javaJNI.XmlManager_createContainer__SWIG_1(this.swigCPtr, this, name, flags, type);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    protected XmlContainer createContainer(String name, int flags) {
        long cPtr = dbxml_javaJNI.XmlManager_createContainer__SWIG_2(this.swigCPtr, this, name, flags);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    protected XmlContainer createContainer(XmlTransaction txn, String name, int flags, int type, int mode) {
        long cPtr = dbxml_javaJNI.XmlManager_createContainer__SWIG_3(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, flags, type, mode);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    protected XmlContainer createContainer(XmlTransaction txn, String name, int flags, int type) {
        long cPtr = dbxml_javaJNI.XmlManager_createContainer__SWIG_4(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, flags, type);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    protected XmlContainer createContainer(XmlTransaction txn, String name, int flags) {
        long cPtr = dbxml_javaJNI.XmlManager_createContainer__SWIG_5(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, flags);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    protected XmlContainer openContainer(String name, int flags) {
        long cPtr = dbxml_javaJNI.XmlManager_openContainer__SWIG_0(this.swigCPtr, this, name, flags);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    protected XmlContainer openContainer(XmlTransaction txn, String name, int flags) {
        long cPtr = dbxml_javaJNI.XmlManager_openContainer__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, flags);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    protected XmlContainer openContainer(String name, int flags, int type, int mode) {
        long cPtr = dbxml_javaJNI.XmlManager_openContainer__SWIG_2(this.swigCPtr, this, name, flags, type, mode);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    protected XmlContainer openContainer(String name, int flags, int type) {
        long cPtr = dbxml_javaJNI.XmlManager_openContainer__SWIG_3(this.swigCPtr, this, name, flags, type);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    protected XmlContainer openContainer(XmlTransaction txn, String name, int flags, int type, int mode) {
        long cPtr = dbxml_javaJNI.XmlManager_openContainer__SWIG_4(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, flags, type, mode);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    protected XmlContainer openContainer(XmlTransaction txn, String name, int flags, int type) {
        long cPtr = dbxml_javaJNI.XmlManager_openContainer__SWIG_5(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, name, flags, type);
        return cPtr == 0L ? null : new XmlContainer(cPtr, true);
    }

    public void dumpContainer(String name, String filename) throws XmlException {
        dbxml_javaJNI.XmlManager_dumpContainer(this.swigCPtr, this, name, filename);
    }

    public void loadContainer(String name, String filename, XmlUpdateContext uc) throws XmlException {
        dbxml_javaJNI.XmlManager_loadContainer(this.swigCPtr, this, name, filename, XmlUpdateContext.getCPtr(uc));
    }

    protected void verifyContainer(String name, String filename, int flags) {
        dbxml_javaJNI.XmlManager_verifyContainer__SWIG_0(this.swigCPtr, this, name, filename, flags);
    }

    public void verifyContainer(String name, String filename) throws XmlException {
        dbxml_javaJNI.XmlManager_verifyContainer__SWIG_1(this.swigCPtr, this, name, filename);
    }

    public XmlQueryExpression prepare(String query, XmlQueryContext context) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_prepare__SWIG_0(this.swigCPtr, this, query, context);
        return cPtr == 0L ? null : new XmlQueryExpression(cPtr, true);
    }

    public XmlQueryExpression prepare(XmlTransaction txn, String query, XmlQueryContext context) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_prepare__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, query, context);
        return cPtr == 0L ? null : new XmlQueryExpression(cPtr, true);
    }

    protected XmlResults query(String query, XmlQueryContext context, int flags) {
        long cPtr = dbxml_javaJNI.XmlManager_query__SWIG_0(this.swigCPtr, this, query, context, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    protected XmlResults query(XmlTransaction txn, String query, XmlQueryContext context, int flags) {
        long cPtr = dbxml_javaJNI.XmlManager_query__SWIG_1(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, query, context, flags);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults query(String query, XmlQueryContext context) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_query__SWIG_2(this.swigCPtr, this, query, context);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults query(XmlTransaction txn, String query, XmlQueryContext context) throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_query__SWIG_3(this.swigCPtr, this, XmlTransaction.getCPtr(txn), txn, query, context);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlResults createResults() throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createResults(this.swigCPtr, this);
        return cPtr == 0L ? null : new XmlResults(cPtr, true);
    }

    public XmlModify createModify() throws XmlException {
        long cPtr = dbxml_javaJNI.XmlManager_createModify(this.swigCPtr, this);
        return cPtr == 0L ? null : new XmlModify(cPtr, true);
    }

    protected XmlTransaction createTransaction(DbTxn toAdopt) {
        long cPtr = dbxml_javaJNI.XmlManager_createTransaction(this.swigCPtr, this, toAdopt);
        return cPtr == 0L ? null : new XmlTransaction(cPtr, true);
    }

    protected XmlIndexLookup createIndexLookupInternal(XmlContainer cont, String uri, String name, String index, XmlValue value, int op) {
        long cPtr = dbxml_javaJNI.XmlManager_createIndexLookupInternal__SWIG_0(this.swigCPtr, this, XmlContainer.getCPtr(cont), cont, uri, name, index, value, op);
        return cPtr == 0L ? null : new XmlIndexLookup(cPtr, true);
    }

    protected XmlIndexLookup createIndexLookupInternal(XmlContainer cont, String uri, String name, String index, XmlValue value) {
        long cPtr = dbxml_javaJNI.XmlManager_createIndexLookupInternal__SWIG_1(this.swigCPtr, this, XmlContainer.getCPtr(cont), cont, uri, name, index, value);
        return cPtr == 0L ? null : new XmlIndexLookup(cPtr, true);
    }

    protected XmlIndexLookup createIndexLookupInternal(XmlContainer cont, String uri, String name, String index) {
        long cPtr = dbxml_javaJNI.XmlManager_createIndexLookupInternal__SWIG_2(this.swigCPtr, this, XmlContainer.getCPtr(cont), cont, uri, name, index);
        return cPtr == 0L ? null : new XmlIndexLookup(cPtr, true);
    }

    public static void setLogLevel(int level, boolean enabled) throws XmlException {
        dbxml_javaJNI.XmlManager_setLogLevel(level, enabled);
    }

    public static void setLogCategory(int category, boolean enabled) throws XmlException {
        dbxml_javaJNI.XmlManager_setLogCategory(category, enabled);
    }

    public static int get_version_major() {
        return dbxml_javaJNI.XmlManager_get_version_major();
    }

    public static int get_version_minor() {
        return dbxml_javaJNI.XmlManager_get_version_minor();
    }

    public static int get_version_patch() {
        return dbxml_javaJNI.XmlManager_get_version_patch();
    }

    public static String get_version_string() {
        return dbxml_javaJNI.XmlManager_get_version_string();
    }

    public XmlDocument createDocumentInternal() throws XmlException {
        return dbxml_javaJNI.XmlManager_createDocumentInternal(this.swigCPtr, this);
    }
}

