/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.debug;

import com.enterprisedt.util.debug.Appender;
import com.enterprisedt.util.debug.Level;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class Logger {
    private static String cvsId = "@(#)$Id: Logger.java,v 1.3 2004/06/25 11:52:26 bruceb Exp $";
    private static Level globalLevel;
    private static SimpleDateFormat format;
    private static Hashtable loggers;
    private static Vector appenders;
    private boolean useLog4j = false;
    private Date ts = new Date();
    private String clazz;
    private Method[][] methods = null;
    private Object logger = null;
    private Object[] argsPlain = new Object[1];
    private Object[] argsThrowable = new Object[2];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Throwable;

    private Logger(String clazz, boolean uselog4j) {
        this.clazz = clazz;
        this.useLog4j = uselog4j;
        if (uselog4j) {
            this.setupLog4j();
        }
    }

    private void setupLog4j() {
        this.methods = new Method[5][2];
        try {
            Class<?> log4jLogger = Class.forName("org.apache.log4j.Logger");
            Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Logger.class$("java.lang.String")) : class$java$lang$String};
            Method getLogger = log4jLogger.getMethod("getLogger", args);
            Object[] invokeArgs = new Object[]{this.clazz};
            this.logger = getLogger.invoke(null, invokeArgs);
            Class[] argsPlain = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Logger.class$("java.lang.Object")) : class$java$lang$Object};
            Class[] argsThrowable = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Logger.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Throwable == null ? (class$java$lang$Throwable = Logger.class$("java.lang.Throwable")) : class$java$lang$Throwable};
            this.methods[0][0] = log4jLogger.getMethod("fatal", argsPlain);
            this.methods[0][1] = log4jLogger.getMethod("fatal", argsThrowable);
            this.methods[1][0] = log4jLogger.getMethod("error", argsPlain);
            this.methods[1][1] = log4jLogger.getMethod("error", argsThrowable);
            this.methods[2][0] = log4jLogger.getMethod("warn", argsPlain);
            this.methods[2][1] = log4jLogger.getMethod("warn", argsThrowable);
            this.methods[3][0] = log4jLogger.getMethod("info", argsPlain);
            this.methods[3][1] = log4jLogger.getMethod("info", argsThrowable);
            this.methods[4][0] = log4jLogger.getMethod("debug", argsPlain);
            this.methods[4][1] = log4jLogger.getMethod("debug", argsThrowable);
        }
        catch (Exception ex) {
            this.useLog4j = false;
            this.error("Failed to initialize log4j logging", ex);
        }
    }

    public static void setLevel(Level level) {
        globalLevel = level;
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String clazz) {
        Logger logger = (Logger)loggers.get(clazz);
        if (logger == null) {
            boolean useLog4j = false;
            String log4j = System.getProperty("edtftp.log.log4j");
            if (log4j != null && log4j.equalsIgnoreCase("true")) {
                useLog4j = true;
            }
            logger = new Logger(clazz, useLog4j);
            loggers.put(clazz, logger);
        }
        return logger;
    }

    public static void addAppender(Appender newAppender) {
        appenders.addElement(newAppender);
    }

    public static void shutdown() {
        for (int i = 0; i < appenders.size(); ++i) {
            Appender a = (Appender)appenders.get(i);
            a.close();
        }
    }

    public void log(Level level, String message, Throwable t) {
        if (this.useLog4j) {
            this.log4jLog(level, message, t);
        } else if (globalLevel.isGreaterOrEqual(level)) {
            this.ourLog(level, message, t);
        }
    }

    private void log4jLog(Level level, String message, Throwable t) {
        Object[] args = null;
        int pos = -1;
        if (t == null) {
            args = this.argsPlain;
            pos = 0;
        } else {
            args = this.argsThrowable;
            args[1] = t;
            pos = 1;
        }
        args[0] = message;
        Method method = this.methods[level.getLevel()][pos];
        try {
            method.invoke(this.logger, args);
        }
        catch (Exception ex) {
            this.ourLog(Level.ERROR, "Failed to invoke log4j method", ex);
            this.ourLog(level, message, t);
        }
    }

    private void ourLog(Level level, String message, Throwable t) {
        this.ts.setTime(System.currentTimeMillis());
        String stamp = format.format(this.ts);
        StringBuffer buf = new StringBuffer(level.toString());
        buf.append(" [").append(this.clazz).append("] ").append(stamp).append(" : ").append(message);
        if (appenders.size() == 0) {
            System.out.println(buf.toString());
            if (t != null) {
                t.printStackTrace(System.out);
            }
        } else {
            for (int i = 0; i < appenders.size(); ++i) {
                Appender a = (Appender)appenders.get(i);
                a.log(buf.toString());
                if (t == null) continue;
                a.log(t);
            }
        }
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public void warn(String message) {
        this.log(Level.WARN, message, null);
    }

    public void warn(String message, Throwable t) {
        this.log(Level.WARN, message, t);
    }

    public void error(String message) {
        this.log(Level.ERROR, message, null);
    }

    public void error(String message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message, null);
    }

    public void fatal(String message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message, null);
    }

    public void debug(String message, Throwable t) {
        this.log(Level.DEBUG, message, t);
    }

    public boolean isEnabledFor(Level level) {
        return globalLevel.isGreaterOrEqual(level);
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(Level.INFO);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        format = new SimpleDateFormat("d MMM yyyy HH:mm:ss.S");
        loggers = new Hashtable(10);
        appenders = new Vector(2);
        String level = System.getProperty("edtftp.log.level", Level.OFF.toString());
        globalLevel = Level.getLevel(level);
    }
}

