/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class UnixFileParser
extends FTPFileParser {
    public static String cvsId = "@(#)$Id: UnixFileParser.java,v 1.6 2004/07/23 08:32:36 bruceb Exp $";
    private static final String TOTAL = "total";
    private static final String SYMLINK_ARROW = "->";
    private static final SimpleDateFormat formatter1 = new SimpleDateFormat("MMM-dd-yyyy", Locale.US);
    private static final SimpleDateFormat formatter2 = new SimpleDateFormat("MMM-dd-yyyy-HH:mm", Locale.US);
    private static final int MIN_FIELD_COUNT = 9;
    private int year = Calendar.getInstance().get(1);

    public FTPFile parse(String raw) throws ParseException {
        String[] fields = this.split(raw);
        if (fields.length == 2 && TOTAL.equalsIgnoreCase(fields[0])) {
            return null;
        }
        if (fields.length < 9) {
            throw new ParseException("Unexpected number of fields: " + fields.length, 0);
        }
        String permissions = fields[0];
        char ch = permissions.charAt(0);
        boolean isDir = false;
        boolean isLink = false;
        if (ch == 'd') {
            isDir = true;
        } else if (ch == 'l') {
            isLink = true;
        }
        String owner = fields[2];
        String group = fields[3];
        long size = 0L;
        String sizeStr = fields[4];
        try {
            size = Long.parseLong(sizeStr);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Failed to parse size: " + sizeStr, 0);
        }
        Date lastModified = null;
        StringBuffer stamp = new StringBuffer(fields[5]);
        stamp.append('-').append(fields[6]).append('-');
        if (fields[7].indexOf(58) < 0) {
            stamp.append(fields[7]);
            lastModified = formatter1.parse(stamp.toString());
        } else {
            stamp.append(this.year).append('-').append(fields[7]);
            lastModified = formatter2.parse(stamp.toString());
        }
        String name = null;
        String linkedname = null;
        int pos = 0;
        boolean ok = true;
        for (int i = 5; i < 9; ++i) {
            if ((pos = raw.indexOf(fields[i], pos)) >= 0) continue;
            ok = false;
            break;
        }
        if (ok) {
            String remainder = raw.substring(pos);
            if (!isLink) {
                name = remainder;
            } else {
                pos = remainder.indexOf(SYMLINK_ARROW);
                if (pos <= 0) {
                    name = remainder;
                } else {
                    int len = SYMLINK_ARROW.length();
                    name = remainder.substring(0, pos).trim();
                    if (pos + len < remainder.length()) {
                        linkedname = remainder.substring(pos + len);
                    }
                }
            }
        } else {
            throw new ParseException("Failed to retrieve name: " + raw, 0);
        }
        FTPFile file = new FTPFile(1, raw, name, size, isDir, lastModified);
        file.setGroup(group);
        file.setOwner(owner);
        file.setLink(isLink);
        file.setLinkedName(linkedname);
        return file;
    }
}

