/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.SequenceConfig;
import com.sleepycat.db.SequenceStats;
import com.sleepycat.db.StatsConfig;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.internal.DbSequence;

public class Sequence {
    private DbSequence seq;
    private int autoCommitFlag;

    Sequence(DbSequence seq, SequenceConfig config) throws DatabaseException {
        this.seq = seq;
        seq.wrapper = this;
        if (seq.get_db().get_transactional()) {
            this.autoCommitFlag = 0x2000000 | (SequenceConfig.checkNull(config).getAutoCommitNoSync() ? 512 : 0);
        }
    }

    public void close() throws DatabaseException {
        this.seq.close(0);
    }

    public long get(Transaction txn, int delta) throws DatabaseException {
        return this.seq.get(txn == null ? null : txn.txn, delta, txn == null ? this.autoCommitFlag : 0);
    }

    public Database getDatabase() throws DatabaseException {
        return this.seq.get_db().wrapper;
    }

    public DatabaseEntry getKey() throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry();
        this.seq.get_key(key);
        return key;
    }

    public SequenceStats getStats(StatsConfig config) throws DatabaseException {
        return this.seq.stat(config.getFlags());
    }
}

