/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class GMonthDayValue
extends AbstractDateTimeValue {
    public GMonthDayValue() throws XPathException {
        super(GMonthDayValue.stripCalendar(TimeUtils.getInstance().newXMLGregorianCalendar(new GregorianCalendar())));
    }

    public GMonthDayValue(XMLGregorianCalendar calendar) throws XPathException {
        super(GMonthDayValue.stripCalendar((XMLGregorianCalendar)calendar.clone()));
    }

    public GMonthDayValue(String timeValue) throws XPathException {
        super(timeValue);
        try {
            if (this.calendar.getXMLSchemaType() != DatatypeConstants.GMONTHDAY) {
                throw new IllegalStateException();
            }
        }
        catch (IllegalStateException e) {
            throw new XPathException("xs:time instance must not have year, month or day fields set");
        }
    }

    private static XMLGregorianCalendar stripCalendar(XMLGregorianCalendar calendar) {
        calendar = (XMLGregorianCalendar)calendar.clone();
        calendar.setYear(Integer.MIN_VALUE);
        calendar.setHour(Integer.MIN_VALUE);
        calendar.setMinute(Integer.MIN_VALUE);
        calendar.setSecond(Integer.MIN_VALUE);
        calendar.setMillisecond(Integer.MIN_VALUE);
        return calendar;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 71: {
                return this;
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:time to " + Type.getTypeName(requiredType));
    }

    protected AbstractDateTimeValue createSameKind(XMLGregorianCalendar cal) throws XPathException {
        return new GMonthDayValue(cal);
    }

    public int getType() {
        return 71;
    }

    protected QName getXMLSchemaType() {
        return DatatypeConstants.GMONTHDAY;
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        throw new XPathException("Subtraction is not supported on values of type " + Type.getTypeName(this.getType()));
    }
}

