/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.security.User;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.XMLDBException;

public class XMLDBDeleteUser
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("delete-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Deletes an existing user in the database. Requires username. Does not delete the user's home collection.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(11, 1));

    public XMLDBDeleteUser(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String user = args[0].getStringValue();
        LocalCollection collection = null;
        try {
            collection = new LocalCollection(this.context.getUser(), this.context.getBroker().getBrokerPool(), XmldbURI.ROOT_COLLECTION_URI, this.context.getAccessContext());
            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
            User userObj = ums.getUser(user);
            if (null != userObj) {
                ums.removeUser(userObj);
            }
        }
        catch (XMLDBException xe) {
            throw new XPathException(this.getASTNode(), "Failed to remove user " + user, xe);
        }
        finally {
            if (null != collection) {
                try {
                    collection.close();
                }
                catch (XMLDBException e) {}
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

