/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.http.servlets.SessionWrapper;
import org.exist.security.User;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.session.SessionModule;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBAuthenticate
extends BasicFunction {
    public static final FunctionSignature authenticateSignature = new FunctionSignature(new QName("authenticate", "http://exist-db.org/xquery/xmldb", "xmldb"), "Check if a user is registered as database user. The function simply tries to read the database collection specified in the first parameter $a, using the supplied username in $b and password in $c. It returns true if the attempt succeeds, false otherwise.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 3), new SequenceType(22, 3)}, new SequenceType(23, 2));
    public static final FunctionSignature loginSignature = new FunctionSignature(new QName("login", "http://exist-db.org/xquery/xmldb", "xmldb"), "Check if a user is registered as database user and change the user identity for the current XQuery script. The function simply tries to read the database collection specified in the first parameter $a, using the supplied username in $b and password in $c. Contrary to the authenticate function,login will set the current user for the xquery script to the authenticated user. It returns true if the attempt succeeds, false otherwise. If called from a HTTP contextthen the login is cached for the lifetime of the HTTP session and may be used for all XQueryscripts in that session.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 3), new SequenceType(22, 3)}, new SequenceType(23, 2));

    public XMLDBAuthenticate(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[1].isEmpty()) {
            return BooleanValue.FALSE;
        }
        String uri = args[0].getStringValue();
        String userName = args[1].getStringValue();
        String password = args[2].getStringValue();
        XmldbURI targetColl = !uri.startsWith("xmldb:") ? XmldbURI.EMBEDDED_SERVER_URI.resolveCollectionPath(XmldbURI.create(uri)) : XmldbURI.create(uri);
        try {
            Collection root = DatabaseManager.getCollection((String)targetColl.toString(), (String)userName, (String)password);
            if (this.isCalledAs("login")) {
                UserManagementService ums = (UserManagementService)root.getService("UserManagementService", "1.0");
                User user = ums.getUser(userName);
                this.context.getBroker().setUser(user);
                this.cacheUserInHttpSession(user);
            }
            return BooleanValue.TRUE;
        }
        catch (XMLDBException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to authenticate user '" + userName + "' on " + uri), (Throwable)e);
            }
            return BooleanValue.FALSE;
        }
    }

    private void cacheUserInHttpSession(User user) throws XPathException {
        JavaObjectValue session;
        SessionModule myModule = (SessionModule)this.context.getModule("http://exist-db.org/xquery/session");
        Variable var = myModule.resolveVariable(SessionModule.SESSION_VAR);
        if (var != null && var.getValue() != null && var.getValue().getItemType() == 100 && (session = (JavaObjectValue)var.getValue().itemAt(0)).getObject() instanceof SessionWrapper) {
            ((SessionWrapper)session.getObject()).setAttribute("_eXist_xmldb_user", (Object)user);
        }
    }
}

