/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.value.EmptySequence;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class Compile
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("compile", "http://exist-db.org/xquery/util", "util"), "Dynamically evaluates the XPath/XQuery expression specified in $a within the current instance of the query engine.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 2));

    public Compile(XQueryContext context) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String expr = args[0].getStringValue();
        if ("".equals(expr.trim())) {
            return new EmptySequence();
        }
        this.context.pushNamespaceContext();
        LOG.debug((Object)("eval: " + expr));
        XQueryLexer lexer = new XQueryLexer(this.context, new StringReader(expr));
        XQueryParser parser = new XQueryParser(lexer);
        XQueryTreeParser astParser = new XQueryTreeParser(this.context);
        try {
            parser.xpath();
            if (parser.foundErrors()) {
                LOG.debug((Object)parser.getErrorMessage());
                throw new XPathException("error found while executing expression: " + parser.getErrorMessage());
            }
            AST ast = parser.getAST();
            PathExpr path = new PathExpr(this.context);
            astParser.xpath(ast, path);
            if (astParser.foundErrors()) {
                throw new XPathException("error found while executing expression: " + astParser.getErrorMessage(), astParser.getLastException());
            }
            path.analyze(new AnalyzeContextInfo());
        }
        catch (RecognitionException e) {
            StringValue stringValue = new StringValue(e.toString());
            return stringValue;
        }
        catch (TokenStreamException e) {
            StringValue stringValue = new StringValue(e.toString());
            return stringValue;
        }
        catch (XPathException e) {
            StringValue stringValue = new StringValue(e.toString());
            return stringValue;
        }
        catch (Exception e) {
            StringValue stringValue = new StringValue(e.getMessage());
            return stringValue;
        }
        finally {
            this.context.popNamespaceContext();
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

