/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.QName;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.util.UtilModule;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class CatchFunction
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("catch", "http://exist-db.org/xquery/util", "util"), "This function corresponds to a try-catch statement in Java. The code block in $b will be put inside a try-catch statement. If an exception is thrown while executing $b, the function checks the name of the exception and calls $c if it matches one of the fully qualified Java class names specified in $a", new SequenceType[]{new SequenceType(22, 6), new SequenceType(11, 7), new SequenceType(11, 7)}, new SequenceType(11, 7));

    public CatchFunction(XQueryContext context) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence exceptionClasses = this.getArgument(0).eval(contextSequence, contextItem);
        LocalVariable mark = this.context.markLocalVariables(false);
        try {
            Sequence sequence = this.getArgument(1).eval(contextSequence, contextItem);
            this.context.popLocalVariables(mark);
            return sequence;
        }
        catch (Throwable throwable) {
            try {
                this.context.popLocalVariables(mark);
                throw throwable;
            }
            catch (Exception e) {
                LOG.debug((Object)("Caught exception in util:catch: " + e.getMessage()));
                if (!(e instanceof XPathException)) {
                    LOG.warn((Object)("Exception: " + e.getMessage()), (Throwable)e);
                }
                this.context.getWatchDog().reset();
                SequenceIterator i = exceptionClasses.iterate();
                while (i.hasNext()) {
                    Item next = i.nextItem();
                    try {
                        Class<?> exClass = Class.forName(next.getStringValue());
                        if (!exClass.getName().equals(e.getClass().getName()) && !exClass.isInstance(e)) continue;
                        LOG.debug((Object)("Calling exception handler to process " + e.getClass().getName()));
                        UtilModule myModule = (UtilModule)this.context.getModule("http://exist-db.org/xquery/util");
                        myModule.declareVariable(UtilModule.EXCEPTION_QNAME, new StringValue(e.getClass().getName()));
                        myModule.declareVariable(UtilModule.EXCEPTION_MESSAGE_QNAME, new StringValue(e.getMessage()));
                        return this.getArgument(2).eval(contextSequence, contextItem);
                    }
                    catch (Exception e2) {
                        if (e2 instanceof XPathException) {
                            throw (XPathException)e2;
                        }
                        throw new XPathException(this.getASTNode(), "Error in exception handler: " + e2.getMessage(), e);
                    }
                }
                if (e instanceof XPathException) {
                    throw (XPathException)e;
                }
                throw new XPathException(e);
            }
        }
    }

    public int returnsType() {
        return this.getArgument(1).returnsType();
    }

    public int getCardinality() {
        return this.getArgument(1).getCardinality();
    }
}

